CREATE TABLE `canob_ak_acl` (   `user_id` bigint(20) unsigned NOT NULL,   `permissions` mediumtext,   PRIMARY KEY (`user_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_ak_profiles` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `configuration` longtext,   `filters` longtext,   PRIMARY KEY (`id`) ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `canob_ak_profiles`  VALUES ('1', 'Default Backup Profile', '###CTR128###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', '');
CREATE TABLE `canob_ak_stats` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `comment` longtext,   `backupstart` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `backupend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `status` enum('run','fail','complete') NOT NULL DEFAULT 'run',   `origin` varchar(30) NOT NULL DEFAULT 'backend',   `type` varchar(30) NOT NULL DEFAULT 'full',   `profile_id` bigint(20) NOT NULL DEFAULT '1',   `archivename` longtext,   `absolute_path` longtext,   `multipart` int(11) NOT NULL DEFAULT '0',   `tag` varchar(255) DEFAULT NULL,   `filesexist` tinyint(3) NOT NULL DEFAULT '1',   `remote_filename` varchar(1000) DEFAULT NULL,   `total_size` bigint(20) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `idx_fullstatus` (`filesexist`,`status`),   KEY `idx_stale` (`status`,`origin`) ) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
INSERT INTO `canob_ak_stats`  VALUES ('2', 'Sauvegarde effectuée le vendredi 18 mai 2012 19:56', '', '2012-05-18 19:56:07', '2012-05-18 19:56:27', 'complete', 'backend', 'full', '1', 'site-joomlatest.grangeweb.ch-20120518-195607.zip', '/home/httpd/vhosts/grangeweb.ch/subdomains/joomlatest/httpdocs/administrator/components/com_akeeba/backup/site-joomlatest.grangeweb.ch-20120518-195607.zip', '0', 'backend', '1', NULL, '30236362');
CREATE TABLE `canob_ak_storage` (   `tag` varchar(255) NOT NULL,   `lastupdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,   `data` longtext,   PRIMARY KEY (`tag`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_assets` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',   `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',   `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',   `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',   `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',   `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',   `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',   `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',   PRIMARY KEY (`id`),   UNIQUE KEY `idx_asset_name` (`name`),   KEY `idx_lft_rgt` (`lft`,`rgt`),   KEY `idx_parent_id` (`parent_id`) ) ENGINE=MyISAM AUTO_INCREMENT=83 DEFAULT CHARSET=utf8;
INSERT INTO `canob_assets`  VALUES ('1', '0', '1', '512', '0', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":[],\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}'), ('3', '1', '3', '6', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('4', '1', '7', '8', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('5', '1', '9', '10', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('6', '1', '11', '12', '1', 'com_config', 'com_config', '{}'), ('7', '1', '13', '18', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('8', '1', '19', '96', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('9', '1', '97', '98', '1', 'com_cpanel', 'com_cpanel', '{}'), ('10', '1', '99', '100', '1', 'com_installer', 'com_installer', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1},\"core.delete\":[],\"core.edit.state\":[]}');
INSERT INTO `canob_assets`  VALUES ('11', '1', '101', '102', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('12', '1', '103', '104', '1', 'com_login', 'com_login', '{}'), ('13', '1', '105', '106', '1', 'com_mailto', 'com_mailto', '{}'), ('14', '1', '107', '108', '1', 'com_massmail', 'com_massmail', '{}'), ('15', '1', '109', '110', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'), ('16', '1', '111', '112', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('17', '1', '113', '114', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('18', '1', '115', '116', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('19', '1', '117', '120', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('20', '1', '121', '122', '1', 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `canob_assets`  VALUES ('21', '1', '123', '124', '1', 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}'), ('22', '1', '125', '126', '1', 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'), ('23', '1', '127', '128', '1', 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('24', '1', '129', '130', '1', 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('25', '1', '131', '148', '1', 'com_weblinks', 'com_weblinks', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('26', '1', '149', '150', '1', 'com_wrapper', 'com_wrapper', '{}'), ('27', '8', '20', '57', '2', 'com_content.category.2', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('28', '3', '4', '5', '2', 'com_banners.category.3', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('29', '7', '14', '15', '2', 'com_contact.category.4', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('30', '19', '118', '119', '2', 'com_newsfeeds.category.5', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `canob_assets`  VALUES ('31', '25', '132', '133', '2', 'com_weblinks.category.6', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('32', '8', '58', '69', '2', 'com_content.category.7', 'Blog', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('33', '60', '78', '79', '4', 'com_content.article.1', 'Modules variables', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('34', '27', '21', '22', '3', 'com_content.article.2', 'Icons', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('35', '27', '23', '24', '3', 'com_content.article.3', 'ZOO', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('36', '27', '25', '26', '3', 'com_content.article.4', 'Typography', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('37', '27', '27', '28', '3', 'com_content.article.5', 'Dummy Content', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('38', '27', '29', '30', '3', 'com_content.article.6', 'Fonctionnalités', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('39', '27', '31', '32', '3', 'com_content.article.7', 'Grangeweb Theme', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('40', '32', '59', '60', '3', 'com_content.article.8', 'Joomla Templates', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `canob_assets`  VALUES ('41', '32', '61', '62', '3', 'com_content.article.9', 'Beautiful Icons', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('42', '32', '63', '64', '3', 'com_content.article.10', 'Warp Theme Framework', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('43', '32', '65', '66', '3', 'com_content.article.11', 'ZOO Extension', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('44', '32', '67', '68', '3', 'com_content.article.12', 'Free Social Icons', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('47', '27', '35', '36', '3', 'com_content.article.14', 'Slideshow', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('48', '27', '37', '38', '3', 'com_content.article.15', 'Lightbox', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('49', '27', '39', '40', '3', 'com_content.article.16', 'Spotlight', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('50', '27', '41', '42', '3', 'com_content.article.17', 'Twitter', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('51', '27', '43', '44', '3', 'com_content.article.18', 'Media Player', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('52', '27', '45', '46', '3', 'com_content.article.19', 'Gallery', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `canob_assets`  VALUES ('53', '27', '47', '48', '3', 'com_content.article.20', 'Map', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('54', '27', '49', '50', '3', 'com_content.article.21', 'Accordion', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('55', '27', '51', '52', '3', 'com_content.article.22', 'Slideset', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('56', '7', '16', '17', '2', 'com_contact.category.8', 'Contacts', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('57', '25', '134', '135', '2', 'com_weblinks.category.9', 'YOOtheme', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('58', '25', '136', '137', '2', 'com_weblinks.category.10', 'YOOtheme Links (2)', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('60', '62', '71', '80', '3', 'com_content.category.11', 'Template Grangeneuve', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('61', '62', '89', '90', '3', 'com_content.article.23', 'Création du site', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('62', '8', '70', '95', '2', 'com_content.category.12', 'Site Grangeweb', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('63', '62', '81', '88', '3', 'com_content.category.13', 'Modules Grangeweb', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `canob_assets`  VALUES ('64', '62', '91', '92', '3', 'com_content.article.24', 'Site de base', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('65', '63', '82', '83', '4', 'com_content.article.25', 'JCE', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('66', '62', '93', '94', '3', 'com_content.article.26', 'Langages', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('67', '60', '72', '73', '4', 'com_content.article.27', 'Mise en place du Template Grangeweb', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('68', '1', '506', '507', '1', 'com_jce', 'jce', '{}'), ('69', '60', '74', '75', '4', 'com_content.article.28', 'Couleur', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('70', '60', '76', '77', '4', 'com_content.article.29', 'Menus', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('71', '1', '508', '509', '1', 'com_phocadownload', 'com_phocadownload', '{}'), ('72', '63', '84', '85', '4', 'com_content.article.30', 'Phoca Downloads', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('73', '80', '145', '146', '3', 'com_weblinks.category.14', 'Téléchargements', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `canob_assets`  VALUES ('74', '80', '143', '144', '3', 'com_weblinks.category.15', 'Editeurs de texte', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('75', '25', '138', '139', '2', 'com_weblinks.category.16', 'Joomla', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('76', '80', '141', '142', '3', 'com_weblinks.category.17', 'Backup', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('78', '63', '86', '87', '4', 'com_content.article.31', 'Akeeba Backup', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('80', '25', '140', '147', '2', 'com_weblinks.category.18', 'Extensions Joomla', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('81', '27', '55', '56', '3', 'com_content.article.32', 'Gallery (2)', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('82', '1', '510', '511', '1', 'com_akeeba', 'akeeba', '{}');
CREATE TABLE `canob_associations` (   `id` varchar(50) NOT NULL COMMENT 'A reference to the associated item.',   `context` varchar(50) NOT NULL COMMENT 'The context of the associated item.',   `key` char(32) NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',   PRIMARY KEY (`context`,`id`),   KEY `idx_key` (`key`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_banner_clients` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL DEFAULT '',   `contact` varchar(255) NOT NULL DEFAULT '',   `email` varchar(255) NOT NULL DEFAULT '',   `extrainfo` text NOT NULL,   `state` tinyint(3) NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `metakey` text NOT NULL,   `own_prefix` tinyint(4) NOT NULL DEFAULT '0',   `metakey_prefix` varchar(255) NOT NULL DEFAULT '',   `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',   `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',   `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',   PRIMARY KEY (`id`),   KEY `idx_own_prefix` (`own_prefix`),   KEY `idx_metakey_prefix` (`metakey_prefix`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_banner_tracks` (   `track_date` datetime NOT NULL,   `track_type` int(10) unsigned NOT NULL,   `banner_id` int(10) unsigned NOT NULL,   `count` int(10) unsigned NOT NULL DEFAULT '0',   PRIMARY KEY (`track_date`,`track_type`,`banner_id`),   KEY `idx_track_date` (`track_date`),   KEY `idx_track_type` (`track_type`),   KEY `idx_banner_id` (`banner_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_banners` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `cid` int(11) NOT NULL DEFAULT '0',   `type` int(11) NOT NULL DEFAULT '0',   `name` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `imptotal` int(11) NOT NULL DEFAULT '0',   `impmade` int(11) NOT NULL DEFAULT '0',   `clicks` int(11) NOT NULL DEFAULT '0',   `clickurl` varchar(200) NOT NULL DEFAULT '',   `state` tinyint(3) NOT NULL DEFAULT '0',   `catid` int(10) unsigned NOT NULL DEFAULT '0',   `description` text NOT NULL,   `custombannercode` varchar(2048) NOT NULL,   `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `metakey` text NOT NULL,   `params` text NOT NULL,   `own_prefix` tinyint(1) NOT NULL DEFAULT '0',   `metakey_prefix` varchar(255) NOT NULL DEFAULT '',   `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',   `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',   `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `language` char(7) NOT NULL DEFAULT '',   PRIMARY KEY (`id`),   KEY `idx_state` (`state`),   KEY `idx_own_prefix` (`own_prefix`),   KEY `idx_metakey_prefix` (`metakey_prefix`),   KEY `idx_banner_catid` (`catid`),   KEY `idx_language` (`language`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_categories` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',   `parent_id` int(10) unsigned NOT NULL DEFAULT '0',   `lft` int(11) NOT NULL DEFAULT '0',   `rgt` int(11) NOT NULL DEFAULT '0',   `level` int(10) unsigned NOT NULL DEFAULT '0',   `path` varchar(255) NOT NULL DEFAULT '',   `extension` varchar(50) NOT NULL DEFAULT '',   `title` varchar(255) NOT NULL,   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `note` varchar(255) NOT NULL DEFAULT '',   `description` mediumtext,   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `access` int(10) unsigned DEFAULT NULL,   `params` text NOT NULL,   `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',   `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',   `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',   `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',   `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',   `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `hits` int(10) unsigned NOT NULL DEFAULT '0',   `language` char(7) NOT NULL,   PRIMARY KEY (`id`),   KEY `cat_idx` (`extension`,`published`,`access`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_path` (`path`),   KEY `idx_left_right` (`lft`,`rgt`),   KEY `idx_alias` (`alias`),   KEY `idx_language` (`language`) ) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;
INSERT INTO `canob_categories`  VALUES ('1', '0', '0', '0', '35', '0', '', 'system', 'ROOT', 'root', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{}', '', '', '', '0', '2009-10-18 16:07:09', '0', '0000-00-00 00:00:00', '0', '*'), ('2', '27', '1', '1', '2', '1', 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:26:37', '0', '0000-00-00 00:00:00', '0', '*'), ('3', '28', '1', '3', '4', '1', 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\",\"foobar\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:27:35', '0', '0000-00-00 00:00:00', '0', '*'), ('4', '29', '1', '5', '6', '1', 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:27:57', '0', '0000-00-00 00:00:00', '0', '*'), ('5', '30', '1', '7', '8', '1', 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:28:15', '0', '0000-00-00 00:00:00', '0', '*'), ('6', '31', '1', '9', '10', '1', 'uncategorised', 'com_weblinks', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:28:33', '0', '0000-00-00 00:00:00', '0', '*'), ('7', '32', '1', '11', '12', '1', 'blog', 'com_content', 'Blog', 'blog', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-05-02 11:42:21', '0', '0000-00-00 00:00:00', '0', '*'), ('8', '56', '1', '13', '14', '1', 'contacts', 'com_contact', 'Contacts', 'contacts', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2012-01-23 15:30:44', '0', '0000-00-00 00:00:00', '0', '*'), ('9', '57', '1', '15', '16', '1', 'yootheme-links', 'com_weblinks', 'YOOtheme', 'yootheme-links', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2012-01-23 15:41:18', '42', '2012-02-28 16:28:05', '0', '*'), ('10', '58', '1', '17', '18', '1', 'yootheme-links-2', 'com_weblinks', 'YOOtheme Links (2)', 'yootheme-links-2', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2012-01-23 15:41:21', '0', '0000-00-00 00:00:00', '0', '*');
INSERT INTO `canob_categories`  VALUES ('11', '60', '12', '20', '21', '2', 'site-grangeweb/template-grangeneuve', 'com_content', 'Template Grangeneuve', 'template-grangeneuve', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2012-02-25 09:50:49', '42', '2012-02-25 09:54:49', '0', '*'), ('12', '62', '1', '19', '24', '1', 'site-grangeweb', 'com_content', 'Site Grangeweb', 'site-grangeweb', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2012-02-25 09:54:22', '0', '0000-00-00 00:00:00', '0', '*'), ('13', '63', '12', '22', '23', '2', 'site-grangeweb/modules-grangeweb', 'com_content', 'Modules Grangeweb', 'modules-grangeweb', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2012-02-25 09:54:36', '42', '2012-02-25 09:54:57', '0', '*'), ('14', '73', '18', '32', '33', '2', 'extensions-joomla/telechargements', 'com_weblinks', 'Téléchargements', 'telechargements', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2012-02-25 16:37:07', '42', '2012-03-07 19:36:11', '0', '*'), ('15', '74', '18', '30', '31', '2', 'extensions-joomla/editeurs-de-texte', 'com_weblinks', 'Editeurs de texte', 'editeurs-de-texte', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2012-02-25 16:41:59', '42', '2012-03-07 19:36:01', '0', '*'), ('16', '75', '1', '25', '26', '1', 'joomla', 'com_weblinks', 'Joomla', 'joomla', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2012-02-25 16:45:47', '0', '0000-00-00 00:00:00', '0', '*'), ('17', '76', '18', '28', '29', '2', 'extensions-joomla/backup', 'com_weblinks', 'Backup', 'backup', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2012-02-25 16:57:05', '42', '2012-03-07 19:35:46', '0', '*'), ('18', '80', '1', '27', '34', '1', 'extensions-joomla', 'com_weblinks', 'Extensions Joomla', 'extensions-joomla', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2012-03-07 19:35:33', '0', '0000-00-00 00:00:00', '0', '*');
CREATE TABLE `canob_contact_details` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `con_position` varchar(255) DEFAULT NULL,   `address` text,   `suburb` varchar(100) DEFAULT NULL,   `state` varchar(100) DEFAULT NULL,   `country` varchar(100) DEFAULT NULL,   `postcode` varchar(100) DEFAULT NULL,   `telephone` varchar(255) DEFAULT NULL,   `fax` varchar(255) DEFAULT NULL,   `misc` mediumtext,   `image` varchar(255) DEFAULT NULL,   `imagepos` varchar(20) DEFAULT NULL,   `email_to` varchar(255) DEFAULT NULL,   `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL DEFAULT '0',   `params` text NOT NULL,   `user_id` int(11) NOT NULL DEFAULT '0',   `catid` int(11) NOT NULL DEFAULT '0',   `access` int(10) unsigned DEFAULT NULL,   `mobile` varchar(255) NOT NULL DEFAULT '',   `webpage` varchar(255) NOT NULL DEFAULT '',   `sortname1` varchar(255) NOT NULL,   `sortname2` varchar(255) NOT NULL,   `sortname3` varchar(255) NOT NULL,   `language` char(7) NOT NULL,   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) NOT NULL DEFAULT '',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `metakey` text NOT NULL,   `metadesc` text NOT NULL,   `metadata` text NOT NULL,   `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',   `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   PRIMARY KEY (`id`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_state` (`published`),   KEY `idx_catid` (`catid`),   KEY `idx_createdby` (`created_by`),   KEY `idx_featured_catid` (`featured`,`catid`),   KEY `idx_language` (`language`),   KEY `idx_xreference` (`xreference`) ) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
INSERT INTO `canob_contact_details`  VALUES ('1', 'John Q. Public', 'john-q-public', 'Chief Information Officer', '1 Infinite Loop', 'Cupertino', 'California', 'USA', '95014', '1-212-555555-1', '1-212-555555-2', 'Lorem ipsum dolor sit amet, consetetur sadipscing elitr.', '', NULL, 'email@0.0.0.0', '0', '-2', '0', '0000-00-00 00:00:00', '1', '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', '0', '8', '1', '', '', '', '', '', '*', '2012-01-23 15:32:10', '42', '', '2012-01-23 15:36:13', '42', '', '', '{\"robots\":\"\",\"rights\":\"\"}', '0', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00'), ('2', 'Jane Q. Public', 'jane-q-public', 'Chief Information Officer', '1 Infinite Loop', 'Cupertino', 'California', 'USA', '95014', '1-212-555555-1', '1-212-555555-2', 'Lorem ipsum dolor sit amet, consetetur sadipscing elitr.', '', NULL, 'email@0.0.0.0', '0', '-2', '0', '0000-00-00 00:00:00', '2', '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', '0', '8', '1', '', '', '', '', '', '*', '2012-01-23 15:36:05', '42', '', '0000-00-00 00:00:00', '0', '', '', '{\"robots\":\"\",\"rights\":\"\"}', '0', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00'), ('3', 'Olivier Guignard', 'olivier-guignard', 'Resp. Laboratoire de Chimie', 'Rte de Grangeneuve 45', 'Posieux', '', '', '1725', '5 57 34', '', '', '', NULL, 'olivier.guignard@fr.ch', '0', '1', '0', '0000-00-00 00:00:00', '3', '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":null,\"linkb_name\":\"\",\"linkb\":null,\"linkc_name\":\"\",\"linkc\":null,\"linkd_name\":\"\",\"linkd\":null,\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', '43', '8', '1', '079 759 04 74', '', '', '', '', '*', '2012-02-28 16:21:17', '42', '', '2012-02-28 16:22:38', '42', '', '', '{\"robots\":\"\",\"rights\":\"\"}', '0', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
CREATE TABLE `canob_content` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',   `title` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `title_alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'Deprecated in Joomla! 3.0',   `introtext` mediumtext NOT NULL,   `fulltext` mediumtext NOT NULL,   `state` tinyint(3) NOT NULL DEFAULT '0',   `sectionid` int(10) unsigned NOT NULL DEFAULT '0',   `mask` int(10) unsigned NOT NULL DEFAULT '0',   `catid` int(10) unsigned NOT NULL DEFAULT '0',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) NOT NULL DEFAULT '',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `images` text NOT NULL,   `urls` text NOT NULL,   `attribs` varchar(5120) NOT NULL,   `version` int(10) unsigned NOT NULL DEFAULT '1',   `parentid` int(10) unsigned NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `metakey` text NOT NULL,   `metadesc` text NOT NULL,   `access` int(10) unsigned NOT NULL DEFAULT '0',   `hits` int(10) unsigned NOT NULL DEFAULT '0',   `metadata` text NOT NULL,   `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',   `language` char(7) NOT NULL COMMENT 'The language code for the article.',   `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',   PRIMARY KEY (`id`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_state` (`state`),   KEY `idx_catid` (`catid`),   KEY `idx_createdby` (`created_by`),   KEY `idx_featured_catid` (`featured`,`catid`),   KEY `idx_language` (`language`),   KEY `idx_xreference` (`xreference`) ) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;
INSERT INTO `canob_content`  VALUES ('1', '33', 'Modules variables', 'modules-variables', '', '<p>Ce thème est fourni avec différents styles de modules, des badges et des icones. Pour chaque module il est possible d\'y assigner un style et de le combiner avec un icone ou un badge afin de personnaliser leur apparence. Voici une liste des options disponibles :</p>\r\n<table class=\"zebra\">\r\n<tbody>\r\n<tr class=\"odd\">\r\n<td class=\"bold\">Styles</td>\r\n<td>Line</td>\r\n</tr>\r\n<tr>\r\n<td class=\"bold\">Badges</td>\r\n<td>Hot, New, Free, Top</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td class=\"bold\">Icones</td>\r\n<td>Download, Twitter, Mail, Bubble, Login, Cart</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>Pour un aperçu de ces modules, cliquez sur <a href=\"index.php?option=com_content&amp;view=article&amp;id=1&amp;Itemid=103\">le lien suivant </a>:</p>', '', '1', '0', '0', '11', '2011-05-02 11:45:23', '42', '', '2012-03-04 14:19:17', '42', '0', '0000-00-00 00:00:00', '2011-05-02 11:45:23', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '7', '0', '10', '', '', '1', '62', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('2', '34', 'Icons', 'icons', '', '<p>YOOtheme is a well-known template and extension provider for Joomla and WordPress who helps you to create professional websites. But to make your website or interface design a real eye-catcher we had one thing missing: Icons! Icons are an essential tool to simplify user interfaces and today almost every major website uses icons to highlight important parts in their content.</p>\r\n\r\n<p>This is why we created a great resource of beautiful and handcrafted icons for web and print projects. We got commercial icon sets including e-commerce, community, file and folder icons and many more as well as many freebies.</p>\r\n\r\n<div class=\"box-content bfc-o\">\r\n\r\n	<img class=\"size-auto align-left\" width=\"300\" height=\"282\" src=\"images/yootheme/icons_club.png\"/>\r\n\r\n	<div class=\"bfc-o\">\r\n\r\n		<h2 style=\"margin-top: 0;\">Club Icons</h2>\r\n\r\n		<p>As a member of our icon club you will get access to hundreds of handcrafted and detailed icons. New icon sets are added continuously!</p>\r\n		<ul class=\"check\">\r\n			<li>Pixel perfect design</li>\r\n			<li>PNGs in 8 sizes from 16x16 to 512x512 pixels</li>\r\n			<li>Handmade and optimized for each size</li>\r\n			<li>Editable vector PDF sources</li>\r\n			<li>Change the colors and customize easily</li>\r\n		</ul>\r\n\r\n		<p><a class=\"button-more\" href=\"http://www.yootheme.com/icons\" target=\"_blank\">Visit Website</a></p>\r\n\r\n	</div>\r\n\r\n</div>', '', '0', '0', '0', '2', '2011-05-02 11:47:01', '42', '', '2011-05-09 19:56:03', '42', '0', '0000-00-00 00:00:00', '2011-05-02 11:47:01', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '3', '0', '11', '', '', '1', '21', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('3', '35', 'ZOO', 'zoo', '', '<a class=\"align-right\" data-lightbox=\"width:852;height:480;autoplay:true;\" href=\"http://www.yootheme.com/videos/zoo_video_tour.mp4\"><img class=\"size-auto\" src=\"images/yootheme/zoo_video_tour.png\" width=\"250\" height=\"110\" alt=\"Take the video tour on the ZOO!\" title=\"Take the video tour on the ZOO!\" /></a>\r\n\r\n<p>ZOO is a flexible and powerful content application builder to manage your content. It provides a much improved Joomla experience. The key feature is the ability to create your very own custom content types. You define what a type is made up of - e.g. text, images or a file download. Any combination is imaginable! You bring the content, ZOO brings the elements to structure it and make it look good!</p>\r\n\r\n<h2>Apps for every Purpose</h2>\r\n\r\n<p>ZOO moves from simply being a CCK to an Application Builder. Apps are extensions for ZOO which are optimized for different purposes and types of content catalogs. ZOO offers a wide range of apps to get you started right away. There is a blog, a product catalog, a cookbook, a business directory, a documentation, a download archive and a movie database app!</p>\r\n\r\n<img class=\"size-auto align-center\" src=\"images/yootheme/zoo_apps.png\" width=\"635\" height=\"219\" alt=\"ZOO Apps for every Purpose\" title=\"ZOO Apps for every Purpose\" />\r\n\r\n<h2>Joomla Integration</h2>\r\n\r\n<p>By now ZOO has developed a thriving ecosystem, with new ZOO extensions appearing regularly. It also integrates well with many popular Joomla extensions. Besides the ZOO component itself offers additional modules and plugins. They allow a seamless integration into Joomla and provide a richer tool set to create your website.</p>\r\n\r\n<a class=\"button-more\" href=\"http://www.yootheme.com/zoo\" target=\"_blank\">Visit Website</a>', '', '0', '0', '0', '2', '2011-05-02 11:47:22', '42', '', '2012-02-13 15:27:33', '42', '0', '0000-00-00 00:00:00', '2011-05-02 11:47:22', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '5', '0', '12', '', '', '1', '17', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('4', '36', 'Typography', 'typography', '', '<p class=\"hps\"><span class=\"hps\">Vous pouvez</span> <span class=\"hps\">créer de magnifiques contenus</span> <span class=\"hps\">en utilisant</span> de simples <span class=\"hps\">éléments</span> <span class=\"hps\">HTML</span>. <span class=\"hps\">Le</span> <span class=\"hps\">\"Warp theme framework\"</span><span class=\"hps\"> propose</span> <span class=\"hps\">quelques modèles</span> <span class=\"hps\">soignés</span> <span class=\"hps\">pour</span> <span class=\"hps\">tous les éléments HTML</span> <span class=\"hps\">et</span> <span class=\"hps\">un grand ensemble de</span> <span class=\"hps\">classes CSS pour</span> donner du <span class=\"hps\">style à votre</span> <span class=\"hps\">contenu</span>. <span class=\"hps\">Le HTML de base</span> <span class=\"hps\">est très facile</span> <span class=\"hps\">à apprendre et </span><span class=\"hps\">ce petit guide</span> <span class=\"hps\">va vous</span> <span class=\"hps\">montrer comment utiliser</span> <span class=\"hps\">tous les styles</span> <span class=\"hps\">fournis par</span> le \"<span class=\"hps\"></span><span class=\"hps\">Warp theme framework\".</span></p>\r\n<h2>Eléments basiques en HTML</h2>\r\n<p class=\"hps\"><span class=\"hps\">Voici</span> <span class=\"hps\">une rapide démonstration de la syntaxe HTML.</span><span class=\"hps\"> La balise </span><span class=\"hps\">&lt;p&gt;</span> <span class=\"hps\">crée</span> <span class=\"hps\">un nouveau paragraphe</span>. <span class=\"hps\">Un petit espace sera créé </span>automatiquement <span class=\"hps\"></span><span class=\"hps\">avant et après</span> <span class=\"hps\">ce dernier.</span> <span class=\"hps\">Pour</span> <span class=\"hps\">transformer du texte en</span> <span class=\"hps\">hypertexte</span> <span class=\"hps\">il suffit d\'utiliser</span> la <a href=\"#\">balise &lt;a&gt;</a>.</p>\r\n<h3>Mise en évidence du texte</h3>\r\n<p>Pour mettre en évidence un texte on utilise <em><em>l\'élément</em> &lt;em&gt;</em> ou, pour en augmenter l\'inportance, l\'élément&nbsp; <strong>&lt;strong&gt;</strong>. Pour mettre en évidence du texte, on peux également utiliser <mark>l\'élément &lt;mark&gt;</mark>. Pour le suivi des modifications d\'un document, il est possible d\'utiliser&nbsp;<del>l\'élément &lt;del&gt;</del> ou <ins>l\'élément &lt;ins&gt;</ins>. Pour définir une abbréviation on utilisera&nbsp; <abbr title=\"Abbreviation Element\">l\'élément &lt;abbr&gt;</abbr> et pour une définition <dfn title=\"Defines a definition term\">l\'élément &lt;dfn&gt;</dfn>.</p>\r\n<h3>Citations et Code</h3>\r\n<p>Une citation à l\'intérieur d\'une phrase peut être définie avec <q>l\'élément &lt;q&gt;</q>.</p>\r\n<blockquote>L\'élément &lt;blockquote&gt; défini une longue citation et crée, par la même occasion, un bloc compact précédé et suivi par une ligne d\'espace.</blockquote>\r\n<p>Pour insérer du code à l\'intérieur d\'une ligne on utilisera <code><code>l\'élément</code> &lt;code&gt;</code>. Pour un code plus conséquent on utilisera l\'élément &lt;pre&gt; qui utilisera un texte préformaté. Ceci créera un nouveau bloc de texte tout en préservant les espaces et les fins de ligne.</p>\r\n<pre>pre {\r\n    margin: 15px 0;\r\n    padding: 10px;\r\n    font-family: \"Courier New\", Courier, monospace;\r\n    font-size: 12px;\r\n    line-height: 18px;\r\n    white-space: pre-wrap;\r\n}\r\n</pre>\r\n<p><small>Utilisez l\'élément &lt;small&gt; pour des commentaires annexes ou de petits caractères.</small></p>\r\n<hr />\r\n<h2>Classes CSS utiles</h2>\r\n<p>Voici une petite démonstration des classes de style CSS fournies par \"Warp framework\".</p>\r\n<h3>Mise en relief du texte</h3>\r\n<p class=\"dropcap\">Pour que la première lettre d\'un paragraphe soit plus grande que le reste du texte il suffi d\'utiliser la classe CSS <code>dropcap</code>. Pour mettre en évidence du texte avec de petits carrés il suffi de combiner <em class=\"box\">l\'élément &lt;em&gt;&nbsp;</em> avec la classe CSS box<code class=\"dropcap\">.</code></p>\r\n<div class=\"box-content\">Pour faire apparaître ce cadre autour d\'un texte on utilisera la classe CSS <code>box-content</code>.</div>\r\n<div class=\"box-note\">Pour ce type de cadre, on utilisera la classe CSS <code>box-note</code>.</div>\r\n<div class=\"box-info\">Pour un cadre avec l\'icône \"information\" on utilisera la classe CSS <code>box-info</code>.</div>\r\n<div class=\"box-warning\">Pour un cadre avec l\'icône \"attention\" on utilisera la classe CSS <code>box-warning</code>.</div>\r\n<div class=\"box-hint\">Pour un cadre avec l\'icône \"Information importante\" on utilisera la classe CSS&nbsp;<code>box-hint</code>.</div>\r\n<div class=\"box-download\">Pour un cadre avec l\'icône \"téléchargement\" on utilisera la classe CSS&nbsp;<code>box-download</code>.</div>\r\n<p>Utilisez la classe CSS <code>dotted</code> pour créer une ligne pointillée horizontale.</p>\r\n<hr class=\"dotted\" />\r\n<h3>Tableau</h3>\r\n<p>Créez un tableau de type zebra en utilisant la classe CSS&nbsp; <code>zebra</code>.</p>\r\n<table class=\"zebra\">\r\n    <caption>Légende du tableau</caption>\r\n    <thead>\r\n        <tr>\r\n            <th>Titre</th><th>Titre</th><th class=\"center\">Titre</th>\r\n        </tr>\r\n    </thead>\r\n    <tfoot>\r\n        <tr>\r\n            <td>Pied de table</td>\r\n            <td>Pied de table</td>\r\n            <td class=\"center\">Pied de table</td>\r\n        </tr>\r\n    </tfoot>\r\n    <tbody>\r\n        <tr class=\"odd\">\r\n            <td>Données</td>\r\n            <td>Données</td>\r\n            <td class=\"center\">Données centrées</td>\r\n        </tr>\r\n        <tr>\r\n            <td class=\"bold\">Données gras</td>\r\n            <td>Données</td>\r\n            <td class=\"center\">Données centrées</td>\r\n        </tr>\r\n        <tr class=\"odd\">\r\n            <td>Données</td>\r\n            <td>Données</td>\r\n            <td class=\"center\">Données centrées</td>\r\n        </tr>\r\n    </tbody>\r\n</table>\r\n<h3>Liste de définitions</h3>\r\n<p>Pour créer une liste de définitions de mots séparés par une ligne, on utilisera la classe CSS <code>separator</code>.</p>\r\n<dl class=\"separator\"><dt>Liste de définitions</dt><dd>Une liste de définitions est une suite de termes avec leur définition correspondante. Pour créer une liste de définition on utilise l\'élément &lt;dl&gt; accompagné de &lt;dt&gt; pour marquer le début de la definition et &lt;dd&gt; pour la définition en elle-même.</dd><dt>Terme à définir</dt><dd>Définition à proprement parlé.</dd><dt>Terme à définir</dt><dd>Définition à proprement parlé.</dd><dd>Autre&nbsp; définition .</dd></dl>\r\n<h3>Formulairess</h3>\r\n<p>Pour créer un formulaire avec des champs de réponse bien arrangés on utilisera la classe CSS <code>box</code>.</p>\r\n<form action=\"#\" class=\"box style\"><fieldset><legend>Légende du formulaire<br /></legend>\r\n    <div><label for=\"f1\">Text input:</label> <input value=\"input text\" id=\"f1\" type=\"text\" /></div>\r\n    <div><label for=\"f2\">Radio input:</label> <input id=\"f2\" type=\"radio\" /></div>\r\n    <div><label for=\"f3\">Checkbox input:</label> <input id=\"f3\" type=\"checkbox\" /></div>\r\n    <div><label for=\"f4\">Select field:</label> <select id=\"f4\"><option>Option 01</option><option>Option 02</option></select></div>\r\n    <div><label for=\"f5\">Textarea:</label><br /><textarea rows=\"5\" cols=\"30\" id=\"f5\">Textarea text</textarea></div>\r\n    </fieldset><button>Button</button> <input value=\"Input Button\" type=\"button\" /></form>', '', '1', '0', '0', '2', '2011-05-02 11:47:45', '42', '', '2012-03-03 19:58:36', '42', '0', '0000-00-00 00:00:00', '2011-05-02 11:47:45', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '25', '0', '13', '', '', '1', '53', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('5', '37', 'Dummy Content', 'dummy-content', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.', '', '1', '0', '0', '2', '2011-05-02 11:48:08', '42', '', '2011-05-02 13:45:48', '42', '0', '0000-00-00 00:00:00', '2011-05-02 11:48:08', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '2', '0', '14', '', '', '1', '8', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('6', '38', 'Fonctionnalités', 'fonctionnalites', '', '<p>Ce thème utilise les toutes dernières fonctionnalités du \"Warp theme framework\". Il est fourni avec un large éventail d\'aspects et de <a href=\"index.php?option=com_content&amp;view=article&amp;id=1&amp;Itemid=103\">variations dans les modules</a>. Il comprend également une splendide <a href=\"index.php?option=com_content&amp;view=article&amp;id=4&amp;Itemid=104\">typographie </a>qui vous permettra de donner du style à votre contenu. voici les principales fonctionalités de ce thème:</p>\r\n<ul class=\"check\">\r\n<li>Disponible pour Joomla et WordPress</li>\r\n<li>Disponible en 5 variations de style</li>\r\n<li>Choix entre 5 couleurs et 8 polices</li>\r\n<li>1 style de module combinable avec 4 badges et 6 icônes</li>\r\n<li>Thème flexible</li>\r\n<li>Disponible avec toutes les fonctionnalités de \"Warp framework\"</li>\r\n</ul>\r\n<h2>Style de thème</h2>\r\n<p>Ce thème est fourni avec différentes variations de style. En plus du thème de base, le paramétrage permet de modifier certains autre aspects tels que des couleurs et différentes polices. la combinaison de ces différents styles vous permettront de créer votre thème personnalisé.</p>\r\n<p><img class=\"size-auto\" src=\"images/yootheme/features_style_settings.png\" alt=\"Combinable Styles\" title=\"\" height=\"155\" width=\"695\" /></p>\r\n<h2>Profiles de thème</h2>\r\n<p>Dans le menu d\'administration des thèmes vous avez le choix entre différents profiles. Vous pouvez modifier les styles, couleurs, polices et les enregistrer sous un nouveau nom. Chaque profile peut être assigné, selon les besoins, à différents menus ou sous-menus. Cliquez sur une des images ci-dessous pour activer le profile :</p>\r\n<div class=\"bfc-o text-center\"><a class=\"align-left\" href=\"index.php?option=com_content&amp;view=article&amp;id=7&amp;Itemid=101&amp;profile=default\"> <figure class=\"remove-margin-t\"> <img class=\"size-auto\" src=\"images/yootheme/features_profile01.jpg\" alt=\"Load Profile Default\" title=\"Load Profile Default\" height=\"150\" width=\"200\" /> <figcaption>Default</figcaption> </figure> </a> <a class=\"align-left\" href=\"index.php?option=com_content&amp;view=article&amp;id=7&amp;Itemid=101&amp;profile=header\"> <figure class=\"remove-margin-t\"> <img class=\"size-auto\" src=\"images/yootheme/features_profile02.jpg\" alt=\"Load Profile Header\" title=\"Load Profile Header\" height=\"150\" width=\"200\" /> <figcaption>Header</figcaption> </figure> </a> <a class=\"align-left\" href=\"index.php?option=com_content&amp;view=article&amp;id=7&amp;Itemid=101&amp;profile=pop\"> <figure class=\"remove-margin-t\"> <img class=\"size-auto\" src=\"images/yootheme/features_profile04.jpg\" alt=\"Load Profile Pop\" title=\"Load Profile Pop\" height=\"150\" width=\"200\" /> <figcaption>Pop</figcaption> </figure> </a> <a class=\"align-left\" href=\"index.php?option=com_content&amp;view=article&amp;id=7&amp;Itemid=101&amp;profile=blocks\"> <figure class=\"remove-margin\"> <img class=\"size-auto\" src=\"images/yootheme/features_profile03.jpg\" alt=\"Load Profile Blocks\" title=\"Load Profile Blocks\" height=\"150\" width=\"200\" /> <figcaption>Blocks</figcaption> </figure> </a> <a class=\"align-left\" href=\"index.php?option=com_content&amp;view=article&amp;id=7&amp;Itemid=101&amp;profile=page\"> <figure class=\"remove-margin\"> <img class=\"size-auto\" src=\"images/yootheme/features_profile05.jpg\" alt=\"Load Profile Page\" title=\"Load Profile Page\" height=\"150\" width=\"200\" /> <figcaption>Page</figcaption> </figure> </a></div>\r\n<h2>Thème</h2>\r\n<p href=\"index.php?option=com_content&amp;view=article&amp;id=1&amp;Itemid=3\">Ce thème est fourni avec les modules standard de Warp6. <span class=\"hps\">Les</span> <span class=\"hps\">positions de modules</span> <span class=\"hps\">permettent de choisir</span> <span class=\"hps\">une mise en page</span> <span class=\"hps\"></span><span class=\"hps\">qui permet de définir</span> <span class=\"hps\">l\'alignement</span> <span class=\"hps\">des module</span> <span class=\"hps\">et les proportions</span>: <em>equal</em>, <em>double</em> ou <em>stack</em>. Vous pouvez facilement composer votre propre mise en page.Les deux barres latérales (sidebars) peuvent être inversées de droite à gauche et leur largeur peut être redéfinie dans le menu administration. Jettez un coup d\'oeil à la page \"<a href=\"index.php?option=com_content&amp;view=article&amp;id=1&amp;Itemid=3\">modules variables</a>\" pour en avoir un aperçu.</p>\r\n<div class=\"grid-block\">\r\n<div class=\"grid-box width50\"><figure class=\"remove-margin\"> <img class=\"size-auto\" src=\"images/yootheme/features_module_positions.png\" alt=\"Module Positions\" title=\"Module Positions\" height=\"414\" width=\"300\" /> <figcaption>Positions des modules</figcaption> </figure></div>\r\n<div class=\"grid-box width50\"><figure class=\"remove-margin-t\"> <img class=\"size-auto\" src=\"images/yootheme/features_module_layouts.png\" alt=\"Module Layouts\" title=\"Module Layouts\" height=\"202\" width=\"300\" /> <figcaption>Aspect des module&nbsp;</figcaption> </figure> <figure class=\"remove-margin-b\"> <img class=\"size-auto\" src=\"images/yootheme/features_column_layouts.png\" alt=\"Colum Layouts\" title=\"Column Layouts\" height=\"172\" width=\"300\" /> <figcaption>Aspect des colonnes</figcaption> </figure></div>\r\n</div>', '', '1', '0', '0', '2', '2011-05-02 11:48:41', '42', '', '2012-03-07 19:41:59', '42', '0', '0000-00-00 00:00:00', '2011-05-02 11:48:41', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '13', '0', '15', '', '', '1', '95', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('7', '39', 'Grangeweb Theme', 'grangeweb-theme', '', '<p>Basé sur le thème Nano de YOOTheme, voici le modèle de site utilisable pour les sites non-officiels de Grangeneuve. Je n\'ai pas pu me résoudre à placer le menu principal sur le côté droit (position sidebar_b) car cele rend le template moins sympa. Pour être parfaitement en phase par rapport à ce que recommande la chancellerie, il suffit de modifier l\'emplacement des deux modules (menu principal et login) dans la position sidebar_b.</p>\r\n<h1>Identification</h1>\r\n<p>Connectez-vous ou, si vous ne possédez pas encore de compte, créez un nouveau compte. Lorsque ce sera fait, vous vous apercevrez que des menus supplémentaire sont disponibles</p>', '', '1', '0', '0', '2', '2011-05-02 11:49:24', '42', '', '2012-05-18 19:50:54', '42', '0', '0000-00-00 00:00:00', '2011-05-02 11:49:24', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '9', '0', '16', '', '', '1', '492', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('8', '40', 'Joomla Templates', 'joomla-templates', '', '<p><a href=\"index.php?option=com_content&amp;view=article&amp;id=8:joomla-templates&amp;catid=7&amp;Itemid=126\"><img class=\"size-auto\" alt=\"Joomla Templates and WordPress Themes\" title=\"Joomla Templates and WordPress Themes\" src=\"images/yootheme/blog_themes.jpg\" height=\"300\" width=\"760\" /></a></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n', '\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', '1', '0', '0', '7', '2011-04-12 11:50:02', '42', '', '2012-03-03 19:26:37', '42', '0', '0000-00-00 00:00:00', '2011-04-12 11:50:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '6', '0', '1', '', '', '1', '3', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('9', '41', 'Beautiful Icons', 'beautiful-icons', '', '<p><a href=\"index.php?option=com_content&amp;view=article&amp;id=9:beautiful-icons&amp;catid=7&amp;Itemid=126\"><img class=\"size-auto\" width=\"760\" height=\"300\" alt=\"Beautiful and handcrafted icons for web and print projects\" title=\"Beautiful and handcrafted icons for web and print projects\" src=\"images/yootheme/blog_icons.jpg\" /></a></p>\r\n\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n\r\n', '\r\n\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', '0', '0', '0', '7', '2011-03-20 11:50:30', '42', '', '2012-01-23 16:43:03', '42', '0', '0000-00-00 00:00:00', '2011-03-20 11:50:30', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '4', '0', '2', '', '', '1', '4', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('10', '42', 'Warp Theme Framework', 'warp-theme-framework', '', '<p><a href=\"index.php?option=com_content&amp;view=article&amp;id=10:warp-theme-framework&amp;catid=7&amp;Itemid=126\"><img class=\"size-auto\" width=\"760\" height=\"300\" alt=\"Warp Theme Framework\" title=\"Warp Theme Framework\" src=\"images/yootheme/blog_warp.jpg\" /></a></p>\r\n\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n\r\n', '\r\n\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', '0', '0', '0', '7', '2011-03-15 11:50:55', '42', '', '2012-01-23 16:43:13', '42', '0', '0000-00-00 00:00:00', '2011-03-15 11:50:55', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '4', '0', '3', '', '', '1', '10', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `canob_content`  VALUES ('11', '43', 'ZOO Extension', 'zoo-extension', '', '<p><img class=\"size-auto\" width=\"760\" height=\"300\" alt=\"ZOO is a flexible and powerful content application builder to manage your content\" title=\"ZOO is a flexible and powerful content application builder to manage your content\" src=\"images/yootheme/blog_zoo.png\" /></p>\r\n\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n\r\n', '\r\n\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', '0', '0', '0', '7', '2011-02-28 11:51:30', '42', '', '2011-05-09 19:55:11', '42', '0', '0000-00-00 00:00:00', '2011-02-28 11:51:30', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '3', '0', '4', '', '', '1', '4', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('12', '44', 'Free Social Icons', 'free-social-icons', '', '<p><a href=\"index.php?option=com_content&amp;view=article&amp;id=12:free-social-icons&amp;catid=7&amp;Itemid=126\"><img class=\"size-auto\" width=\"760\" height=\"300\" alt=\"Free Social Icons Set\" title=\"Free Social Icons Set\" src=\"images/yootheme/blog_social_icons.jpg\" /></a></p>\r\n\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n\r\n', '\r\n\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', '0', '0', '0', '7', '2011-01-14 11:51:53', '42', '', '2012-01-23 16:43:24', '42', '0', '0000-00-00 00:00:00', '2011-01-14 11:51:53', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '4', '0', '5', '', '', '1', '2', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('13', '59', 'Widgetkit', 'widgetkit', '', '<p>Widgetkit est un regroupement de tous les anciens outils connus sous le terme de YOOTools. A travers un interface simple, cet outil permet d\'enrichir votre site web avec des composants tels que des diaporamas, des galeries d\'images, des \"lightboxes\" ... Tous ces outils utilisent des technologies récentes telles que le HTML5, les outils CSS3 et les scripts Java basés sur&nbsp; jQuery. Widgetkit fonctionne également sur des iPads, iPhones et les téléphones et tablettes Android. Voici un rapide tour des fonctionnalités disponibles:</p>\r\n<h2>Fonctionnalités</h2>\r\n<ul class=\"check\">\r\n<li>Disponible pour Joomla et WordPress</li>\r\n<li>Tous les widgets peuvent fonctionner de manière indépendante</li>\r\n<li>Utilisation d\'un code rapide pour afficher le widgets n\'importe ou</li>\r\n<li>Code simple et léger</li>\r\n<li>Utilise les balises HTML5 </li>\r\n<li><span class=\"hps\">Prise en charge</span> <span class=\"hps\">des gestes</span> <span class=\"hps\">tactiles pour</span> <span class=\"hps\">appareils mobiles</span></li>\r\n<li>Utilise les accélérateur matériel d\'animations CSS3</li>\r\n<li>Construit en HTML5, CSS3, PHP 5.2+, et la dernière version de jQuery </li>\r\n</ul>\r\n<h2>Comment fonctionne-t-il ?</h2>\r\n<p><span class=\"hps\">Widgetkit</span> <span class=\"hps\">agit donc comme</span> <span class=\"hps\">une plate-forme</span> <span class=\"hps\">pour tous les </span><span class=\"hps\">widgets</span>. <span class=\"hps\">Il s\'installe comme</span> <span class=\"hps\">un seul composant dans</span> <span class=\"hps\">Joomla ou</span> <span class=\"hps\">comme un plugin</span> <span class=\"hps\">dans WordPress</span>. <span class=\"hps\">Le tableau de bord</span> <span class=\"hps\">Widgetkit</span> <span class=\"hps\">vous présente un</span> <span class=\"hps\">aperçu</span> <span class=\"hps\">de tous les widgets</span>. <span class=\"hps\">Vous pouvez créer</span>, <span class=\"hps\">modifier ou supprimer</span> <span class=\"hps\">tous les widgets</span> <span class=\"hps\">et leur contenu</span> <span class=\"hps\">directement dans ce tableau de bord</span>. A<span class=\"hps\">près</span> avoir <span class=\"hps\">créé</span> <span class=\"hps\">le contenu de votre</span> <span class=\"hps\">premier widget</span>, vous pouvez soit <span class=\"hps\">utiliser un</span> <span class=\"hps\">shortcode</span> soit <span class=\"hps\">un module</span> <span class=\"hps\">pour afficher votre</span> <span class=\"hps\">widget n\'importe où</span> <span class=\"hps\">sur votre site web</span>. <span class=\"hps\">En fait, vous</span> <span class=\"hps\">pouvez faire les deux</span>, car après avoir<span class=\"hps\"></span> <span class=\"hps\">créé un widget</span> <span class=\"hps\">vous êtes</span> <span class=\"hps\">en mesure de</span> <span class=\"hps\">l\'afficher</span> <span class=\"hps\">plusieurs fois et</span> <span class=\"hps\">le réutiliser sur</span> <span class=\"hps\">différentes parties de votre</span> <span class=\"hps\">site web</span>.</p>', '', '1', '0', '0', '2', '2011-06-08 09:34:41', '42', '', '2012-03-04 11:33:00', '42', '0', '0000-00-00 00:00:00', '2011-06-08 09:34:41', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '8', '0', '10', '', '', '1', '105', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('14', '47', 'Slideshow', 'slideshow', '', '<p>Le Widgetkit Slideshow est un excellent gestionnaire d\'images et de diaporamas pour Joomla. <span class=\"hps\">Il est souple</span>, <span class=\"hps\">facile à personnaliser</span> <span class=\"hps\">et complètement</span> <span class=\"hps\">construit avec</span> <span class=\"hps\">HTML5 et CSS3</span>.</p>\r\n<h2>Caractéristiques</h2>\r\n<ul class=\"check\">\r\n<li>Un<span class=\"hps\"> code clair </span><span class=\"hps\">et très léger</span></li>\r\n<li>17 somptueux effets de transition</li>\r\n<li><span class=\"hps\">Utilise</span> <span class=\"hps\">l\'accélération matérielle</span> <span class=\"hps\">des animations</span> <span class=\"hps\">CSS3</span></li>\r\n<li>A<span class=\"hps\">nimation</span> <span class=\"hps\">JavaScript compatibles avec </span><span class=\"hps\">tous les browser </span><span class=\"hps\">Internet</span></li>\r\n<li><span id=\"result_box\" class=\"short_text\" lang=\"fr\"><span class=\"hps\">Prise en charge de</span> <span class=\"hps\">légendes</span> <span class=\"hps\">HTML</span></span></li>\r\n<li>Convient à la navigation sur téléphone mobile</li>\r\n<li>Construit en HTML5, CSS3, PHP 5.2+, et la dernière version de jQuery</li>\r\n</ul>\r\n<h2>Exemples de Slideshow</h2>\r\n<p>Ce diaporama utilise le fameux effet de Ken Burns.</p>\r\n<p>[widgetkit id=45]</p>\r\n<h2>Exemple standard de Slideshow</h2>\r\n<p>Voici un diaporama <span class=\"hps\">avec effets de transition</span> <span class=\"hps\">accrocheurs</span>.</p>\r\n<p>[widgetkit id=10]</p>\r\n<h2>Exemple de Showcase Box</h2>\r\n<p>Ce contenu de démonstration utilise toutes les fonctionnalités du Widget pour des besoins de navigation. <span class=\"hps\">Tous les types de</span> <span class=\"hps\">contenu HTML</span> <span class=\"hps\">peuvent être utilisés</span> <span class=\"hps\">dans ce type de navigation</span>.</p>\r\n<p>[widgetkit id=37]</p>\r\n<h2>Exemple de bouton Showcase</h2>\r\n<p>Ce diaporama avec de splendides boutons de navigation. Il est possible de placer toute sorte de HTML dans ces boutons de navigation.</p>\r\n<p>[widgetkit id=41]</p>\r\n<h2>Exemple d\'onglets</h2>\r\n<p>This is a classic, tabbed slideshow. Tabs can be aligned to the left, right and center.</p>\r\n<p>[widgetkit id=35]</p>\r\n<h2>Exemple de barre d\'onglets</h2>\r\n<p>Voici une barre d\'onglets typique. Chacun peut être aligné à gauche, droite ou centré.</p>\r\n<p>[widgetkit id=34]</p>\r\n<h2>Exemple de liste</h2>\r\n<p>Ce diaporama comprend une liste verticale de navigation.</p>\r\n<p>[widgetkit id=36]</p>\r\n<h2>Comment l\'utiliser ?</h2>\r\n<p><span class=\"hps\">Le</span> <span class=\"hps\">diaporama</span> <span class=\"hps\">Widgetkit</span> <span class=\"hps\">tire pleinement parti</span> <span class=\"hps\">de la</span> <span class=\"hps\">très conviviale</span> <span class=\"hps\">interface utilisateur</span> administrateur de <span class=\"hps\">Widgetkit</span><span class=\"hps\">.</span> <span class=\"hps\">Il</span> <span class=\"hps\">n\'a jamais</span> <span class=\"hps\">été aussi facile de</span> <span class=\"hps\">créer et de gérer</span> <span class=\"hps\">tous les diaporamas</span> <span class=\"hps\">et de leurs</span> <span class=\"hps\">différentes diapositives</span> <span class=\"hps\">en un seul endroit. <span class=\"hps\">Après avoir créé</span> <span class=\"hps\">un Slideshow </span><span class=\"hps\">vous pouvez le charger</span> <span class=\"hps\">n\'importe où sur votre</span> <span class=\"hps\">site web en utilisant</span> <span class=\"hps\">des numéros courts</span> (p.ex : widgetkit id=36 entre crochet) <span class=\"hps\">ou</span> <span class=\"hps\">le module W</span><span class=\"hps\">idgetkit</span> <span class=\"hps\">Joomla</span><span class=\"hps\"></span><span class=\"hps\">.</span></span></p>', '', '1', '0', '0', '2', '2011-06-08 09:34:56', '42', '', '2012-03-04 14:39:13', '42', '0', '0000-00-00 00:00:00', '2011-06-08 09:34:56', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '11', '0', '9', '', '', '1', '42', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('15', '48', 'Lightbox', 'lightbox', '', '<p>Le Widgetkit Lightbox vous permet de visualiser des images, des contenus multimédias et HTML dans une fenêtre flottante noire tamisée sans devoir quitter la page en cours.</p>\r\n<h2>Caractéristiques</h2>\r\n<ul class=\"check\">\r\n<li>Affiche les images, vidéos, HTML, Iframes, requêtes Ajax et SWF</li>\r\n<li>Prend en charge YouTube, Vimeo, MP4 (h.264), WebM et les films FLV</li>\r\n<li>Lightbox permet de mélanger différents types de contenu</li>\r\n<li>Une conception adaptée pour s\'adapter à des images grand sur les appareils mobiles</li>\r\n<li>Permet de charger d\'autres widgets dans la visionneuse</li>\r\n<li>3 differentes transitions d\'ouverture et de fermeture</li>\r\n<li>4 styles différents de légendes</li>\r\n<li>Navigation par le clavier et la molette de la souris</li>\r\n<li>Construit en HTML5, CSS3, PHP 5.2+, et la dernière version de jQuery</li>\r\n</ul>\r\n<h2>Examples</h2>\r\n<p>Differentes animations - <code>fade</code>, <code>elastic</code> et <code>none</code></p>\r\n<p class=\"gallery\"><a data-lightbox=\"transitionIn:fade;transitionOut:fade;\" href=\"images/yootheme/widgetkit/lightbox/image1_lightbox.jpg\"><img src=\"images/yootheme/widgetkit/lightbox/image1.jpg\" alt=\"Lightbox Image\" height=\"120\" width=\"180\" /></a> <a data-lightbox=\"transitionIn:elastic;transitionOut:elastic;\" href=\"images/yootheme/widgetkit/lightbox/image2_lightbox.jpg\"><img src=\"images/yootheme/widgetkit/lightbox/image2.jpg\" alt=\"Lightbox Image\" height=\"120\" width=\"180\" /></a> <a data-lightbox=\"transitionIn:none;transitionOut:none;\" href=\"images/yootheme/widgetkit/lightbox/image3_lightbox.jpg\"><img src=\"images/yootheme/widgetkit/lightbox/image3.jpg\" alt=\"Lightbox Image\" height=\"120\" width=\"180\" /></a></p>\r\n<p>Differentes position des titres&nbsp; - <code>float</code>, <code>inside</code> et <code>over</code></p>\r\n<p class=\"gallery\"><a data-lightbox=\"group:mygroup1;titlePosition:float\" href=\"images/yootheme/widgetkit/lightbox/image4_lightbox.jpg\" title=\"Title Position: Float\"><img src=\"images/yootheme/widgetkit/lightbox/image4.jpg\" alt=\"Lightbox Image\" height=\"120\" width=\"180\" /></a> <a data-lightbox=\"group:mygroup1;titlePosition:inside\" href=\"images/yootheme/widgetkit/lightbox/image5_lightbox.jpg\" title=\"Title Position: Inside\"><img src=\"images/yootheme/widgetkit/lightbox/image5.jpg\" alt=\"Lightbox Image\" height=\"120\" width=\"180\" /></a> <a data-lightbox=\"group:mygroup1;titlePosition:over;padding:0\" href=\"images/yootheme/widgetkit/lightbox/image6_lightbox.jpg\" title=\"Title Position: Over and Padding set to 0\"><img src=\"images/yootheme/widgetkit/lightbox/image6.jpg\" alt=\"Lightbox Image\" height=\"120\" width=\"180\" /></a></p>\r\n<p>Divers exemples dans la même galerie (essayez aussi en utilisant le clavier et la molette de la souris)</p>\r\n<ul>\r\n<li><a data-lightbox=\"group:mygroup2\" href=\"http://www.youtube.com/watch?v=R55e-uHQna0\" title=\"YouTube Video\">YouTube</a></li>\r\n<li><a data-lightbox=\"group:mygroup2\" href=\"http://vimeo.com/15261921\" title=\"Vimeo Video\">Vimeo</a></li>\r\n<li><a data-lightbox=\"group:mygroup2;autoplay:true;\" href=\"http://www.yootheme.com/videos/mediaplayer.mp4\" title=\"MP4 (h.264)\">MP4 (h.264)</a></li>\r\n<li><a data-lightbox=\"group:mygroup2\" href=\"http://www.adobe.com/jp/events/cs3_web_edition_tour/swfs/perform.swf\" title=\"Flash Swf\">Swf</a></li>\r\n<li><a data-lightbox=\"group:mygroup2\" href=\"#inline\" title=\"Inline Content from the Website\">Inline</a></li>\r\n<li><a data-lightbox=\"group:mygroup2;width:1000;height:600\" title=\"Iframe\" href=\"http://www.wikipedia.org\">Iframe</a></li>\r\n</ul>\r\n<div style=\"display: none;\">\r\n<div id=\"inline\" style=\"width: 400px; height: 100px; overflow: auto;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</div>\r\n</div>\r\n<h2>Charger des Widgets dans un Lightbox</h2>\r\n<p>Utilisez <code>#wk-ID</code> pour charger un Widget tel que Slideshow ou une Galleries dans un lightbox. Par exemple: <a data-lightbox=\"width:600;height:300;\" href=\"#wk-50\" title=\"Widgetkit Slideshow\">Widgetkit Slideshow</a></p>\r\n<pre>&lt;a data-lightbox=\"width:600;height:300;\" href=\"#wk-10\"&gt;Lightbox&lt;/a&gt;</pre>\r\n<h2>Comment utiliser ?</h2>\r\n<p>Utilisez l\'attribut de données personnalisé HTML5&nbsp; <code>data-lightbox</code> pour activer le lightbox. L\'attribut de données permet de modifier différents paramètres. Par exemple:</p>\r\n<pre>&lt;a data-lightbox=\"width:1000;height:600;\" href=\"http://www.wikipedia.org\"&gt;Lightbox&lt;/a&gt;</pre>\r\n<p>Voici une liste de paramètres les plus courants:</p>\r\n<ul>\r\n<li><strong>titlePosition</strong> - Comment afficher le titre? (<code>float</code>, <code>outside</code>, <code>inside</code> or <code>over</code>)</li>\r\n<li><strong>transitionIn</strong> - Défini la transition d\'ouverture. (<code>fade</code>, <code>elastic</code>, or <code>none</code>)</li>\r\n<li><strong>transitionOut</strong> -&nbsp;Défini la transition de fermeture (<code>fade</code>, <code>elastic</code>, or <code>none</code>)</li>\r\n<li><strong>overlayShow</strong> - Défini à <code>true</code> ou <code>false</code></li>\r\n<li><strong>scrolling</strong> -&nbsp;Défini à <code>yes</code> ou <code>no</code></li>\r\n<li><strong>width</strong> - Défini une largeur en pixel</li>\r\n<li><strong>height</strong> - Défini une hauteur en pixel<strong></strong></li>\r\n<li><strong>padding</strong> - Défini un remplissage en pixel</li>\r\n</ul>', '', '1', '0', '0', '2', '2011-06-08 09:35:11', '42', '', '2012-03-07 16:43:05', '42', '0', '0000-00-00 00:00:00', '2011-06-08 09:35:11', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '5', '0', '8', '', '', '1', '24', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('16', '49', 'Spotlight', 'spotlight', '', '<p>Le Widgetkit Spotlight vous permet d\'ajouter une superposition à une image qui disparait lorsque le curseur de la souris passe par-dessus. La superposition peux provenir d\'une image ou d\'un contenu HTML. Cet outil se conjugue parfaitement avec le Widget Lightbox.</p>\r\n<h2>Caractéristiques</h2>\r\n<ul class=\"check\">\r\n<li>Crée un jolie animation pour la superposition d\'images</li>\r\n<li>Prise en charge d\'images personnalisées ou de contenus HTML</li>\r\n<li>5 differents modes d\'animation</li>\r\n<li>Construit avec la dernière version de jQuery</li>\r\n</ul>\r\n<h2>Exemples</h2>\r\n<p>Si aucune image de recouvrement n\'est défini par défaut, Spotlight utilise un agrandissement de l\'image. Si vous définissez un recouvrement personnalisé, vous pouvez choisir parmis différentes animations&nbsp; - <code>fade</code>, <code>bottom</code>, <code>top</code>, <code>right</code> et <code>left</code>.</p>\r\n<div><a data-spotlight=\"on\" data-lightbox=\"transitionIn:elastic;transitionOut:elastic;\" href=\"images/yootheme/widgetkit/lightbox/image1_lightbox.jpg\"> <img src=\"images/yootheme/widgetkit/lightbox/image1.jpg\" alt=\"Spotlight Image\" height=\"120\" width=\"180\" /> </a> <a data-spotlight=\"effect:bottom;\" data-lightbox=\"transitionIn:elastic;transitionOut:elastic;\" href=\"images/yootheme/widgetkit/lightbox/image2_lightbox.jpg\"> <img src=\"images/yootheme/widgetkit/lightbox/image2.jpg\" alt=\"Spotlight Image\" height=\"120\" width=\"180\" />\r\n<div class=\"overlay\">Custom Overlay (Bottom)</div>\r\n</a> <a data-spotlight=\"effect:right;\" data-lightbox=\"transitionIn:elastic;transitionOut:elastic;\" href=\"images/yootheme/widgetkit/lightbox/image3_lightbox.jpg\"> <img src=\"images/yootheme/widgetkit/lightbox/image3.jpg\" alt=\"Spotlight Image\" height=\"120\" width=\"180\" />\r\n<div class=\"overlay\">Custom Overlay (Right)</div>\r\n</a></div>\r\n<div><a data-spotlight=\"effect:fade;\" data-lightbox=\"transitionIn:elastic;transitionOut:elastic;\" href=\"images/yootheme/widgetkit/lightbox/image4_lightbox.jpg\"> <img src=\"images/yootheme/widgetkit/lightbox/image4.jpg\" alt=\"Spotlight Image\" height=\"120\" width=\"180\" />\r\n<div class=\"overlay\"><img src=\"images/yootheme/widgetkit/lightbox/image4_spotlight.jpg\" alt=\"Spotlight Image\" height=\"120\" width=\"180\" /></div>\r\n</a> <a data-spotlight=\"effect:top;\" data-lightbox=\"transitionIn:elastic;transitionOut:elastic;\" href=\"images/yootheme/widgetkit/lightbox/image5_lightbox.jpg\"> <img src=\"images/yootheme/widgetkit/lightbox/image5.jpg\" alt=\"Spotlight Image\" height=\"120\" width=\"180\" />\r\n<div class=\"overlay\">Custom Overlay (Top)</div>\r\n</a> <a data-spotlight=\"effect:left;\" data-lightbox=\"transitionIn:elastic;transitionOut:elastic;\" href=\"images/yootheme/widgetkit/lightbox/image6_lightbox.jpg\"> <img src=\"images/yootheme/widgetkit/lightbox/image6.jpg\" alt=\"Spotlight Image\" height=\"120\" width=\"180\" />\r\n<div class=\"overlay\">Custom Overlay (Left)</div>\r\n</a></div>\r\n<h2>Comment l\'utiliser ?</h2>\r\n<p>Utilisez l\'attribut personnalisé de données HTML5&nbsp; <code>data-spotlight</code> pour activer le spotlight.</p>\r\n<pre>&lt;a data-spotlight=\"on\" href=\"/mypage.html\"&gt;\r\n	&lt;img src=\"/image.jpg\" width=\"180\" height=\"120\" alt=\"\" /&gt;\r\n&lt;/a&gt;</pre>\r\n<p>&nbsp;</p>\r\n<p>Pour créer un recouvrement personnalisé, utilisez un élément div avec la classe CSS <code>overlay</code>. Vous pouvez associer le parametre d\'effet aux attributs des données. Par exemple:</p>\r\n<pre>&lt;a data-spotlight=\"effect:bottom;\" href=\"/mypage.html\"&gt;\r\n	&lt;img src=\"/image.jpg\" width=\"180\" height=\"120\" alt=\"\" /&gt;\r\n	&lt;div class=\"overlay\"&gt;Custom Overlay&lt;/div&gt;\r\n&lt;/a&gt;</pre>\r\n<p>Vous pouvez définir les paramètres d\'effet suivant <code>fade</code>, <code>bottom</code>, <code>top</code>, <code>right</code> et <code>left</code>.</p>', '', '1', '0', '0', '2', '2011-06-08 09:35:24', '42', '', '2012-03-07 17:26:59', '42', '0', '0000-00-00 00:00:00', '2011-06-08 09:35:24', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '4', '0', '7', '', '', '1', '19', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('17', '50', 'Twitter', 'twitter', '', '<p>Le <strong>module</strong> Widgetkit Twitter est la plus élégante façon d\'afficher les tweets directement sur votre site web. Tous les tweets affichés sont mis en cache afin qu\'ils s\'affichent très rapidement, même si Twitter n\'est pas disponible.</p>\r\n<h2>Caractéristiques</h2>\r\n<ul class=\"check\">\r\n<li>Filtre des tweets par hashtags, mots, utilisateur, références</li>\r\n<li>Bloque les tweets en utilisant une blacklist</li>\r\n<li>Les tweets sont mis en cache pour une meilleure performance</li>\r\n<li>Les tweets s\'affichent même&nbsp; si Twitter n\'est pas disponible</li>\r\n<li>3 differents styles d\'afficher les tweets</li>\r\n<li>Construit en HTML5 en utilisant les éléments d\'articles et de temps</li>\r\n</ul>\r\n<h2>Comment l\'utiliser ?</h2>\r\n<p>Créer un module Twitter dans Joomla et le publier dans une position module. Un grand nombre d\'options sont disponibles pour choisir les tweets que vous voulez montrer.<br />Par exemple, vous pouvez afficher les tweets seulement à partir d\'un utilisateur spécifique ou les tweets qui contiennent un certain hash-tag ou un mot spécifique. Toutes les options peuvent être combinées. Pour filtrer par plus d\'un mot ou d\'un utilisateur d\'utiliser un espace entre eux. Par exemple : <code>yootheme joomla</code>.</p>', '', '1', '0', '0', '2', '2011-06-08 09:35:35', '42', '', '2012-03-07 17:26:32', '42', '0', '0000-00-00 00:00:00', '2011-06-08 09:35:35', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '5', '0', '6', '', '', '1', '18', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('18', '51', 'Media Player', 'media-player', '', '<p>Le Widgetkit Media Player est un lecteur audio et un lecteur vidéo HTML5 entièrement construit en HTML et CSS. Vous pouvez facilement intégrer des fichiers vidéo dans votre site web en utilisant l\'élément vidéo HTML5. Un simulateur Flash Player est inclus pour tous les navigateurs qui ne le prennent pas en charge.</p>\r\n<h2>Caractéristiques</h2>\r\n<ul class=\"check\">\r\n<li>Lecture native pour les navigateurs modernes qui supportent HTML5</li>\r\n<li>Prise en charge de MP4 (h.264), WebM, FLV, WMV et des fichiers MP3</li>\r\n<li>Entièrement construit en HTML et CSS</li>\r\n<li>Même interface utilisateur dans tous les navigateurs</li>\r\n<li>Créez vos propres skins</li>\r\n<li>Flash player inclus pour les navigateurs qui ne le prenne pas en charge browsers</li>\r\n</ul>\r\n<h2>Exemples</h2>\r\n<p><video width=\"640\" height=\"360\" poster=\"http://www.yootheme.com/videos/mediaplayer.jpg\" controls=\"controls\" preload=\"none\">  <source type=\"video/mp4\" src=\"http://www.yootheme.com/videos/mediaplayer.mp4\" /></video></p>\r\n<p>Voici un titre audio en MP3:</p>\r\n<p><audio src=\"http://www.yootheme.com/videos/mediaplayer.mp3\" type=\"audio/mp3\" controls=\"controls\" preload=\"none\" class=\"/mp3\"></audio></p>\r\n<h2>Comment l\'utiliser ?</h2>\r\n<p>Utiliser l\'élément HTML5 <code>video</code> pour intégrer une vidéo dasn votre site web. Par exemple:</p>\r\n<pre>&lt;video src=\"/video.mp4\" width=\"320\" height=\"240\"&gt;&lt;/video&gt;</pre>\r\n<p>Vous pouvez également fournir de multiples sources, pour ajouter le support à différents formats vidéo comme le H.264, WebM ou Ogg:</p>\r\n<pre>&lt;video width=\"320\" height=\"240\"&gt;\r\n	&lt;source type=\"video/mp4\"  src=\"/video.mp4\" /&gt;\r\n	&lt;source type=\"video/webm\" src=\"/video.webm\" /&gt;\r\n	&lt;source type=\"video/ogg\"  src=\"/video.ogv\" /&gt;\r\n&lt;/video&gt;\r\n</pre>\r\n<p>Utilisez l\'élément HTML5 <code>audio</code> pour intégrer des fichiers MP3 dans votre site web. Par exemple:</p>\r\n<pre>&lt;audio src=\"/audio.mp3\" type=\"audio/mp3\"&gt;&lt;/audio&gt;</pre>', '', '1', '0', '0', '2', '2011-07-31 16:30:20', '42', '', '2012-03-07 17:25:14', '42', '42', '2013-05-24 15:01:34', '2011-07-31 16:30:20', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '5', '', '', '1', '22', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('19', '52', 'Gallery', 'gallery', '', '<p>Le Widgetkit Gallery <span class=\"hps\">fournit</span> <span class=\"hps\">un moyen intelligent et</span> <span class=\"hps\">automatisé pour</span> <span class=\"hps\">publier des images</span> <span class=\"hps\">sur votre site web</span>. <span class=\"hps\">Il vous suffit de</span> <span class=\"hps\">sélectionner les</span> <span class=\"hps\">dossiers d\'images</span> <span class=\"hps\">et toute la</span><span class=\"hps\"> galerie</span> <span class=\"hps\">est générée automatiquement</span>.</p>\r\n<h2>Caractéristiques</h2>\r\n<ul class=\"check\">\r\n<li><span class=\"hps\">Livré avec</span> <span class=\"hps\">mur d\'images</span>, <span class=\"hps\">curseur et</span> <span class=\"hps\">styles de diaporamas</span></li>\r\n<li>Sélection d\'images basée sur un répertoire</li>\r\n<li>Peux prendre en charge plusieur dossiers d\'images</li>\r\n<li>Création automatique de miniatures</li>\r\n<li><span class=\"hps\">Prise en charge de</span> <span class=\"hps\">légendes d\'images</span> <span class=\"hps\">et de liens</span> <span class=\"hps\">personnalisés</span></li>\r\n<li>Utilise les Widgetkit Spotlight et Lightbox</li>\r\n<li>Construit en HTML5, CSS3, PHP 5.2+, et la dernière version de jQuery</li>\r\n</ul>\r\n<h2>Boîte de présentation</h2>\r\n<p><span class=\"hps alt-edited\">Voici une</span> <span class=\"hps\">vitrine</span> <span class=\"hps\">d\'image avec</span> <span class=\"hps\">des effets de transition</span> <span class=\"hps\">accrocheurs</span> <span class=\"hps\">et une navigation</span> <span class=\"hps\">par vignette.</span></p>\r\n<p>[widgetkit id=39]</p>\r\n<h2>Mur d\'images</h2>\r\n<p><span class=\"hps alt-edited\">Voici un </span><span class=\"hps\">mur d\'images</span> <span class=\"hps\">avec</span> <span class=\"hps\">effet de zoom</span>, <span class=\"hps\">pas de marges</span> <span class=\"hps\">et</span> <span class=\"hps\">des coins carrés</span> <span class=\"hps\">avec utilisation possible de la visionneuse L</span>ightbox.</p>\r\n<p>[widgetkit id=24]</p>\r\n<h2>Exemple de Polaroid </h2>\r\n<p><span class=\"hps alt-edited\">Voici un</span> <span class=\"hps\">mur d\'images</span> <span class=\"hps\">avec des photos</span> <span class=\"hps\">polaroid</span> <span class=\"hps\">dispersés</span> <span class=\"hps\">et agrandissable à l\'aide</span> <span class=\"hps\">de la</span> <span class=\"hps\">visionneuse</span> Lightbox.</p>\r\n<p>[widgetkit id=25]</p>\r\n<h2>Exemple de diaporama 1</h2>\r\n<p>Voici un effet \"Slider\" qui centre automatiquement l\'image sur laquelle l\'effet est appliqué. <span class=\"hps\">L\'image agrandie à l\'aide</span> <span class=\"hps\">de la</span> <span class=\"hps\">visionneuse</span> LightboxI dispose également&nbsp; d\'une légende.</p>\r\n<p>[widgetkit id=27]</p>\r\n<h2>Exemple de diaporama 2</h2>\r\n<p>Voici un effet \"Slider\" où les images restent alignées à gauche durant l\'effet.</p>\r\n<p>[widgetkit id=31]</p>\r\n<h2>Exemple d\'écran de diaporama</h2>\r\n<p><span class=\"hps alt-edited\">Voici un</span> <span class=\"hps\">galerie d\'images</span> <span class=\"hps\">en utilisant l\'effet</span> \"swipe\" du Widget SlideShow.</p>\r\n<p>[widgetkit id=48]</p>\r\n<h2>Exemple de diaporama par défaut</h2>\r\n<p>Cette gallerie d\'images utilise toutes les <span class=\"hps\">fonctionnalités</span> <span class=\"hps\"></span>du Widget Slideshow.</p>\r\n<p>[widgetkit id=19]</p>\r\n<h2>Exemple de démonstration</h2>\r\n<p>Cette gallerie d\'images mélange toutes les fonctionnalités des Widgets Slideshow et Slideset.</p>\r\n<p>[widgetkit id=40]</p>\r\n<h2>Exemple de \"Spotlight\" </h2>\r\n<p><span class=\"hps alt-edited\">Voici un</span> <span class=\"hps\">mur d\'images</span> <span class=\"hps\">avec des marges</span> <span class=\"hps\">et des coins arrondis</span> qui utilise les Widget Spotlight et Lightbox.</p>\r\n<p>[widgetkit id=23]</p>\r\n<h2>Slideset Example</h2>\r\n<p>Cette <span class=\"hps\">galerie d\'images</span> <span class=\"hps\">utilise</span> <span class=\"hps\">toutes les fonctionnalités</span> <span class=\"hps\">du widget</span> Slideset widget.</p>\r\n<p>[widgetkit id=44]</p>\r\n<h2>Comment l\'utiliser ?</h2>\r\n<p class=\"hps\">Le Widgetkit Gallery <span class=\"hps\">est livré avec une</span> <span class=\"hps\">interface d\'administration conviviale</span> <span class=\"hps\">qui permet de modifier ou de </span><span class=\"hps\">créez</span> <span class=\"hps\">de nouvelles galeries</span> en quelques clics. <span class=\"hps\">Le</span> <span class=\"hps\">navigateur</span> <span class=\"hps\">intégré</span> <span class=\"hps\">vous permet d\'ajouter </span><span class=\"hps\">ou de supprimer facilement </span><span class=\"hps\">des répertoires</span> <span class=\"hps\">d\'</span><span class=\"hps\">images.</span> Toute les galeries <span class=\"hps\"><span class=\"hps\">peuvent être chargées</span> <span class=\"hps\">n\'importe où sur votre</span> <span class=\"hps\">site web en utilisant</span> <span class=\"hps\">des numéros courts</span> (p.ex : widgetkit id=23 entre crochet) <span class=\"hps\">ou</span> en utilisant <span class=\"hps\">le module W</span><span class=\"hps\">idgetkit</span> <span class=\"hps\">Joomla</span><span class=\"hps\"></span><span class=\"hps\">.</span></span></p>', '', '1', '0', '0', '2', '2011-07-31 16:30:30', '42', '', '2012-03-07 15:13:43', '42', '0', '0000-00-00 00:00:00', '2011-07-31 16:30:30', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '5', '0', '4', '', '', '1', '23', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('20', '53', 'Map', 'map', '', '<p class=\"hps\">Le Widgetkit Map <span class=\"hps\">fournit</span> <span class=\"hps\">une solution</span> <span class=\"hps\">simple pour ajouter</span> <span class=\"hps\">une carte</span> <span class=\"hps\">à votre site Web</span>. <span class=\"hps\">Diverses caractéristiques</span> <span class=\"hps\">vous permettent de personnaliser</span> <span class=\"hps\">la carte</span> <span class=\"hps\">comme par exemple le choix des</span><span class=\"hps\"> couleurs, </span><span class=\"hps\">ajouter de marqueurs</span> <span class=\"hps\">ou des itinéraires</span>.</p>\r\n<h2>Caractéristiques</h2>\r\n<ul class=\"check\">\r\n<li><span class=\"hps\">Sélection de l\'emplacement</span> <span class=\"hps\"></span> <span class=\"hps\">par géolocalisation</span></li>\r\n<li><span class=\"hps\">Prise en charge </span><span class=\"hps\">de carte</span> <span class=\"hps\">multiples</span> <span class=\"hps\">avec</span> <span class=\"hps\"><span class=\"hps\">marqueurs </span>et popups</span></li>\r\n<li>Option pour obtenir l\'itinéraire vers le marqueur actif</li>\r\n<li><span class=\"hps\">Permet de personnaliser </span><span class=\"hps\">les styles de</span> <span class=\"hps\">cartes avec d</span><span class=\"hps\">es couleurs</span></li>\r\n<li>Utilise le tout dernier \"Google Maps API\"</li>\r\n<li>Construit en HTML5, CSS3, PHP 5.2+, et la dernière version de jQuery</li>\r\n</ul>\r\n<h2>Exemple d\'itinéraire</h2>\r\n<p><span class=\"hps\">Cette carte</span> <span class=\"hps\">dispose de toutes</span> <span class=\"hps\">les fonctionnalités </span><span class=\"hps\">d\'une carte Google</span>, affiche des marqueurs <span class=\"hps\">multiples</span> <span class=\"hps\">et vous permet d\'obtenir un itinéraire</span>.</p>\r\n<p>[widgetkit id=26]</p>\r\n<p>[widgetkit id=51]</p>\r\n<h2>Exemple de cartes de couleur</h2>\r\n<p><span class=\"hps\">Définir ou</span> <span class=\"hps\">inverser la</span> <span class=\"hps\">teinte, la saturation</span>, la luminosité <span class=\"hps\">et la valeur \"gamma</span>\" <span class=\"hps\">d\'une carte</span>.</p>\r\n<p>[widgetkit id=28]</p>\r\n<h2>Petite Carte</h2>\r\n<p><span class=\"hps\">Cette carte</span> <span class=\"hps\">a une largeur fixe</span>, aucun contrôle <span class=\"hps\">et aucun</span> <span class=\"hps\">marqueur</span>.</p>\r\n<p>[widgetkit id=29]</p>\r\n<h2>Comment l\'utiliser ?</h2>\r\n<p>Avec le Widgetkit Map <span class=\"hps\">vous pouvez rapidement</span> <span class=\"hps\">créer et gérer</span> <span class=\"hps\">des cartes simples</span> <span class=\"hps\">avec</span> <span class=\"hps\">des fonctionnalités telles que</span> <span class=\"hps\">les marqueurs</span> <span class=\"hps\">multiples</span>, les popups <span class=\"hps\">texte</span> <span class=\"hps\">et des couleurs</span> <span class=\"hps\">personnalisées</span>.<span class=\"hps\"><span class=\"hps\"> Après avoir créé</span> <span class=\"hps\">une carte </span><span class=\"hps\">vous pouvez le charger</span> <span class=\"hps\">n\'importe où sur votre</span> <span class=\"hps\">site web en utilisant</span> <span class=\"hps\">des numéros courts</span> (p.ex : widgetkit id=28 entre crochet) <span class=\"hps\">ou</span> <span class=\"hps\">via le module W</span><span class=\"hps\">idgetkit</span> <span class=\"hps\">Joomla</span><span class=\"hps\"></span><span class=\"hps\">.</span></span></p>', '', '1', '0', '0', '2', '2011-07-31 16:30:42', '42', '', '2012-03-07 15:15:10', '42', '0', '0000-00-00 00:00:00', '2011-07-31 16:30:42', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '5', '0', '3', '', '', '1', '22', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `canob_content`  VALUES ('21', '54', 'Accordion', 'accordion', '', '<p class=\"hps\">Le Widgetkit Accordion&nbsp;<span class=\"hps\">vous permet d\'afficher</span> <span class=\"hps\">un ensemble</span> <span class=\"hps\">d\'éléments dans</span> <span class=\"hps\">un espace compact</span>. <span class=\"hps\">Pour dàvelopper ou réduire la section concernée, il suffi de cliquer sur</span> <span class=\"hps\">une en-tête</span> <span class=\"hps\">d\'articles</span> de la section correspondante<span class=\"hps\"></span><span class=\"hps\"></span>.</p>\r\n<h2>Caractéristiques</h2>\r\n<ul class=\"check\">\r\n<li><span class=\"hps\">Un code clair </span><span class=\"hps\">et très léger</span></li>\r\n<li>Transition soignée entre le contenu des sections</li>\r\n<li>Option de mise à l\'échelle automatique des contenus de différente hauteur</li>\r\n<li>Option de fermeture automatique de multiple artcles ouverts simultanément</li>\r\n<li>Construit en HTML5, CSS3, PHP 5.2+, et la dernière version de jQuery </li>\r\n</ul>\r\n<h2>Example</h2>\r\n<p>[widgetkit id=30]</p>\r\n<h2>Comment l\'utiliser ?</h2>\r\n<p>Le Widgetkit Accordion <span class=\"hps\">vous permet de</span> <span class=\"hps\">créer et gérer facilement</span> <span class=\"hps\">tous les contenus</span> <span class=\"hps\">des accordéons</span> <span class=\"hps\">à travers l\'interface</span> <span class=\"hps\">conviviale</span> <span class=\"hps\">Widgetkit</span> <span class=\"hps\">administration.</span> <span class=\"hps\">Après avoir créé</span> <span class=\"hps\">un accordéon</span> <span class=\"hps\">vous pouvez le charger</span> <span class=\"hps\">n\'importe où sur votre</span> <span class=\"hps\">site web en utilisant</span> <span class=\"hps\">des numéros courts</span> (p.ex : widgetkit id=30 entre crochet) <span class=\"hps\">ou</span> <span class=\"hps\">le module W</span><span class=\"hps\">idgetkit</span> <span class=\"hps\">Joomla</span><span class=\"hps\"></span><span class=\"hps\">.</span></p>', '', '1', '0', '0', '2', '2011-07-31 16:30:54', '42', '', '2012-03-04 12:32:47', '42', '0', '0000-00-00 00:00:00', '2011-07-31 16:30:54', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '2', '', '', '1', '14', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('22', '55', 'Slideset', 'slideset', '', '<p>Le Widgetkit Slideset apporte un nouveau niveau au diaporama.&nbsp;<span class=\"hps\">Il</span> <span class=\"hps\">fournit un moyen</span> <span class=\"hps\">élégant</span> <span class=\"hps\">de montrer</span> <span class=\"hps\">plusieurs ensembles</span> <span class=\"hps\">d\'éléments</span> et utilise un effet très lisse lorsque l\'on se déplace au travers.</p>\r\n<h2>Caractéristiques</h2>\r\n<ul class=\"check\">\r\n<li>Un<span class=\"hps\"> code clair </span><span class=\"hps\">et très léger</span></li>\r\n<li>Somptueux effets de transition</li>\r\n<li>Permet de renommer des ensembles</li>\r\n<li>Convient à la navigation sur téléphone mobile</li>\r\n<li>Construit en HTML5, CSS3, PHP 5.2+, et la dernière version de jQuery</li>\r\n</ul>\r\n<h2>Exemples de diapositives</h2>\r\n<p>Les groupes de dias sont créés automatiquement (4 dias par groupe), leur nom, les boutons de navigation ainsi qu\'un effet d\'apparition sont activés.</p>\r\n<p>[widgetkit id=32]</p>\r\n<h2>Exemple de zoom</h2>\r\n<p>Ce groupe est arrangé manuellement, le nom des groupes est utilisé pour la navigation et un effet Zoom est utilisé pour l\'affichage.</p>\r\n<p>[widgetkit id=33]</p>\r\n<h2>Exemple de chute</h2>\r\n<p>Ce groupe affiche le nom des articles, les boutons de navigation et utilise un effet de chute comme transition.</p>\r\n<p>[widgetkit id=49]</p>\r\n<h2>Exemple de pont (Deck)</h2>\r\n<p>Ce groupe, généré automatiquement, utilise les boutons Suiv./Préc. pour la navigation ainsi qu\'un effet de transition de type Pont.</p>\r\n<p>[widgetkit id=43]</p>\r\n<h2>Comment&nbsp; l\'utiliser ?</h2>\r\n<p>Le Widgetkit Slideset&nbsp;<span class=\"hps\">tire pleinement parti</span> <span class=\"hps\">de la</span> <span class=\"hps\">très conviviale</span> <span class=\"hps\">interface d\'administration de </span><span class=\"hps\">Widgetkit</span><span class=\"hps\">.</span> <span class=\"hps\">Vous pouvez</span> <span class=\"hps\">créer et gérer tous</span> <span class=\"hps\">les</span> <span class=\"hps\">slidesets</span> <span class=\"hps\">et</span> <span class=\"hps\">leurs</span> <span class=\"hps\">différents éléments dans</span> <span class=\"hps\">un seul endroit</span>.<span class=\"hps\"><span class=\"hps\"> Après avoir créé</span> <span class=\"hps\">un Slideset </span><span class=\"hps\">vous pouvez le charger</span> <span class=\"hps\">n\'importe où sur votre</span> <span class=\"hps\">site web en utilisant</span> <span class=\"hps\">des numéros courts</span> (p.ex : widgetkit id=49 entre crochet) <span class=\"hps\">ou</span> <span class=\"hps\">le module W</span><span class=\"hps\">idgetkit</span> <span class=\"hps\">Joomla</span><span class=\"hps\"></span><span class=\"hps\">.</span></span></p>', '', '1', '0', '0', '2', '2011-07-31 16:31:07', '42', '', '2012-03-04 14:38:53', '42', '0', '0000-00-00 00:00:00', '2011-07-31 16:31:07', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '7', '0', '1', '', '', '1', '29', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('23', '61', 'Création du site', 'creation-du-site', '', '<p>Voici les principales étapes qui ont été nécessaires à la création de ce site.</p>\r\n<p>Je vais découper ce sujeten plusieurs parties :</p>\r\n<ul>\r\n<li>Joomla 2.5.x</li>\r\n<li><a href=\"index.php/creation-du-site/template-grangeweb\">Template</a></li>\r\n<li><a href=\"index.php/creation-du-site/modules-indispensables\">Modules indispensables</a></li>\r\n</ul>', '', '1', '0', '0', '12', '2012-02-25 09:53:34', '42', '', '2012-05-18 19:46:28', '42', '0', '0000-00-00 00:00:00', '2012-02-25 09:53:34', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '4', '0', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', ''), ('24', '64', 'Site de base', 'site-de-base', '', '<p>Tout d\'abord, ce site est basé sur le Template Nano de YOOTheme.com. J\'ai donc téléchargé ce Template complet avec les modules YOO, les images, les contenus exemples et le moteur Joomla 2.5.1 intégré.</p>\r\n<p>Après avoir déployé tous ces fichiers sur cet espace d\'hébergement, le paramétrage pouvait commencer.</p>', '', '1', '0', '0', '12', '2012-02-25 10:01:10', '42', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2012-02-25 10:01:10', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '1', '0', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', ''), ('25', '65', 'JCE', 'jce', '', '<p>Le premier module installé a été JCE. L\'éditeur de base de Joomla étant trop limité pour permettre une bonne édition des articles.</p>\r\n<p>Le module de base (gratuit) apporte déjà une amélioration considérable. Les compléments payants (plugins) apportent des fonctionnalités non négligeables mais ,si on les utilisent avec satisfaction, la question du financement de ces modules devrait être planifié.</p>\r\n<p>Tous ces Plugins se trouvent sous la rubrique \"téléchargements\". Le module de base est à <a target=\"_blank\" href=\"index.php/liens?task=weblink.go&amp;id=5\">télécharger sur le site officiel</a>.</p>\r\n<p>Dans les téléchargements on trouvera :</p>\r\n<p>{phocadownload view=category|id=5|text=JCE Plugins à installer à partir de Joomla|target=s}</p>\r\n<p>{phocadownload view=category|id=6|text=JCE Plugins à installer à partir de JCE|target=s}</p>\r\n<p>Une fois le composant installé, ne pas oublier de passer dans le menu \"Site\" - \"Configuration\" afin de définir JCE comme editeur par défaut.</p>', '', '1', '0', '0', '13', '2012-02-25 10:04:07', '42', '', '2012-03-03 21:57:28', '42', '0', '0000-00-00 00:00:00', '2012-02-25 10:04:07', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '7', '0', '1', '', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', ''), ('26', '66', 'Langages', 'languages', '', '<p>Première étape du paramétrage : l\'installation des langages.</p>\r\n<p>A partir de la plateforme Joomla.org, j\'ai téléchargé les paquets langages FR et DE. L\'installation est effectuée comme toutes les installations Joomla via le menu \"Extensions manager\" ou \"Gestion des extensions\" en français.</p>\r\n<p>Une fois ces modules langues installés, le menu \"Extensions\" - \"Gestion des langues\" permet de définir la langue par défaut  du site de de la partie administration (Frontend - Backend). Le troisième onglet va permettre de définir les langues à choix d\'un site multilingue mais cette partie de l\'installation sera traitée plus tard.</p>', '', '1', '0', '0', '12', '2012-02-25 10:01:10', '42', '', '2012-02-27 19:43:34', '42', '0', '0000-00-00 00:00:00', '2012-02-25 10:01:10', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '7', '0', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', ''), ('27', '67', 'Mise en place du Template Grangeweb', 'mise-en-place-du-template-grangeweb', '', '<h3>Avant toute chose; la virgule !!!</h3>\r\n<p><img style=\"float: right;\" alt=\"logo\" src=\"images/grangeweb/logo.png\" height=\"100\" width=\"120\" /></p>\r\n<p>Le fichier contenant le logo officiel de l\'état doit tout d\'abord être téléchargé dans le répertoire des médias. Afin de simplifier l\'organisation des fichiers média du template, j\'ai créé un répertoire \"grangeweb\" qui contiendra toutes les images nécessaires à l\'identité visuelle du site.</p>\r\n<p>En filtrant les modules sur leur position, un seul utilise la position \"Logo\". Il porte également le même nom. A l\'intérieur de ce module HTML, de la même manière qu\'un article, l\'édition de cette partie du template est très souple. Il nous suffi d\'éditer le texte et les images qui somposeront le logo.</p>\r\n<h3>Et encore une virgule !!!</h3>\r\n<p>La deuxième virgule visible dans notre site et le \"favicon\". Ce petit icone s\'affiche dans la ligne d\'adresse de votre browser internet. Par défaut c\'est le logo Joomla qui s\'affiche. Pour le remplacer, il suffi de remplacer le fichier \"favicon.ico\" situé à la racine de votre répertoire du template utilisé (p.ex : /httpdocs/templates/yoo_nano/favicon.ico\"</p>', '', '1', '0', '0', '11', '2012-02-25 10:41:04', '42', '', '2012-03-03 19:26:45', '42', '0', '0000-00-00 00:00:00', '2012-02-25 10:41:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '9', '0', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', ''), ('28', '69', 'Couleur', 'couleur', '', '<h3>Ajout d\'un trait rouge !!!</h3>\r\n<p>D\'après la nouvelle IV de l\'Etat, une couleur bien définie est associée à chaque dicastère. Pour ce qui est de la DIAF c\'est la couleur #97233F.</p>\r\n<p>Vous pouvez la retrouver dans la position \"headerbar\" en dessous du \"bonhomme\".</p>', '', '1', '0', '0', '11', '2012-02-25 13:13:29', '42', '', '2012-03-01 21:34:44', '42', '0', '0000-00-00 00:00:00', '2012-02-25 13:13:29', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '3', '', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', ''), ('29', '70', 'Menus', 'menus', '', '<p>Le template par défaut contient trois menus :</p>\r\n<p>Le menu principal, le menu situé tout en haut après la date (topmenu) et le menu situé dans le pied de page (footmenu).</p>\r\n<p>Pour déplacer le menu principal à gauche, il faudrait lui attribuer la mposition \"sidebar-b\" à la place de sa position actuelle \"menu\". </p>', '', '1', '0', '0', '11', '2012-02-25 13:15:17', '42', '', '2012-02-27 19:45:11', '42', '0', '0000-00-00 00:00:00', '2012-02-25 13:15:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '7', '0', '2', '', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', ''), ('30', '72', 'Phoca Downloads', 'phoca-downloads', '', '<p>Afin de réunir tous les fichiers et de le mettre à disposition des autres utilisateurs essayons la suite Phoca.</p>\r\n<ol>\r\n<li>Installer le module</li>\r\n<li>Installer le plugin ainsi que son module de traduction. Il permet d\'afficher des liens, catégories et fichiers du composant Phoca Download dans un article.</li>\r\n<li>Installer le plugin bouton et sa traduction. Il affiche un bouton dans l\'éditeur de texte pour ajouter facilement des fichiers Phoca Download dans un article.</li>\r\n</ol>', '', '1', '0', '0', '13', '2012-02-25 16:07:14', '42', '', '2012-02-27 19:44:42', '42', '0', '0000-00-00 00:00:00', '2012-02-25 16:07:14', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', '');
INSERT INTO `canob_content`  VALUES ('31', '78', 'Akeeba Backup', 'akeeba-backup', '', '<p>Le meilleur outil gratuit de sauvegarde / Backup de sites Joomla est indéniablement AKEEBA. Cet outil permet non seulement d\'effectuer des sauvegardes des sites entiers (fichiers + base de données) mais permet également de redéployer facilement ces sites.</p>\r\n<p>Ces sauvegardes peuvent être manuelles ou automatisées et cet outil est également capable de créer des points de sauvegarde afin de restaurer un site après une installation défectueuse.</p>\r\n<p>A conseiller vivement sur chaque site Joomla.</p>', '', '1', '0', '0', '13', '2012-02-25 17:06:02', '42', '', '2012-02-27 19:44:42', '42', '0', '0000-00-00 00:00:00', '2012-02-25 17:06:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '1', '0', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', ''), ('32', '81', 'Gallery (2)', 'gallery-2', '', '<p>Le Widgetkit Gallery <span class=\"hps\">fournit</span> <span class=\"hps\">un moyen intelligent et</span> <span class=\"hps\">automatisé pour</span> <span class=\"hps\">publier des images</span> <span class=\"hps\">sur votre site web</span>. <span class=\"hps\">Il vous suffit de</span> <span class=\"hps\">sélectionner les</span> <span class=\"hps\">dossiers d\'images</span> <span class=\"hps\">et toute la</span><span class=\"hps\"> galerie</span> <span class=\"hps\">est générée automatiquement</span>.</p>\r\n<h2>Caractéristiques</h2>\r\n<ul class=\"check\">\r\n<li><span class=\"hps\">Livré avec</span> <span class=\"hps\">mur d\'images</span>, <span class=\"hps\">curseur et</span> <span class=\"hps\">styles de diaporamas</span></li>\r\n<li>Sélection d\'images basée sur un répertoire</li>\r\n<li>Peux prendre en charge plusieur dossiers d\'images</li>\r\n<li>Création automatique de miniatures</li>\r\n<li><span class=\"hps\">Prise en charge de</span> <span class=\"hps\">légendes d\'images</span> <span class=\"hps\">et de liens</span> <span class=\"hps\">personnalisés</span></li>\r\n<li>Utilise les Widgetkit Spotlight et Lightbox</li>\r\n<li>Construit en HTML5, CSS3, PHP 5.2+, et la dernière version de jQuery</li>\r\n</ul>\r\n<h2>Boîte de présentation</h2>\r\n<p><span class=\"hps alt-edited\">Voici une</span> <span class=\"hps\">vitrine</span> <span class=\"hps\">d\'image avec</span> <span class=\"hps\">des effets de transition</span> <span class=\"hps\">accrocheurs</span> <span class=\"hps\">et une navigation</span> <span class=\"hps\">par vignette.</span></p>\r\n<p>[widgetkit id=39]</p>\r\n<h2>Mur d\'images</h2>\r\n<p><span class=\"hps alt-edited\">Voici un </span><span class=\"hps\">mur d\'images</span> <span class=\"hps\">avec</span> <span class=\"hps\">effet de zoom</span>, <span class=\"hps\">pas de marges</span> <span class=\"hps\">et</span> <span class=\"hps\">des coins carrés</span> <span class=\"hps\">avec utilisation possible de la visionneuse L</span>ightbox.</p>\r\n<p>[widgetkit id=24]</p>\r\n<h2>Exemple de Polaroid</h2>\r\n<p><span class=\"hps alt-edited\">Voici un</span> <span class=\"hps\">mur d\'images</span> <span class=\"hps\">avec des photos</span> <span class=\"hps\">polaroid</span> <span class=\"hps\">dispersés</span> <span class=\"hps\">et agrandissable à l\'aide</span> <span class=\"hps\">de la</span> <span class=\"hps\">visionneuse</span> Lightbox.</p>\r\n<p>[widgetkit id=25]</p>\r\n<h2>Exemple de diaporama 1</h2>\r\n<p>Voici un effet \"Slider\" qui centre automatiquement l\'image sur laquelle l\'effet est appliqué. <span class=\"hps\">L\'image agrandie à l\'aide</span> <span class=\"hps\">de la</span> <span class=\"hps\">visionneuse</span> LightboxI dispose également&nbsp; d\'une légende.</p>\r\n<p>[widgetkit id=27]</p>\r\n<h2>Exemple de diaporama 2</h2>\r\n<p>Voici un effet \"Slider\" où les images restent alignées à gauche durant l\'effet.</p>\r\n<p>[widgetkit id=31]</p>\r\n<h2>Exemple d\'écran de diaporama</h2>\r\n<p><span class=\"hps alt-edited\">Voici un</span> <span class=\"hps\">galerie d\'images</span> <span class=\"hps\">en utilisant l\'effet</span> \"swipe\" du Widget SlideShow.</p>\r\n<p>[widgetkit id=48]</p>\r\n<h2>Exemple de diaporama par défaut</h2>\r\n<p>Cette gallerie d\'images utilise toutes les <span class=\"hps\">fonctionnalités</span> <span class=\"hps\"></span>du Widget Slideshow.</p>\r\n<p>[widgetkit id=19]</p>\r\n<h2>Exemple de démonstration</h2>\r\n<p>Cette gallerie d\'images mélange toutes les fonctionnalités des Widgets Slideshow et Slideset.</p>\r\n<p>[widgetkit id=40]</p>\r\n<h2>Exemple de \"Spotlight\"</h2>\r\n<p><span class=\"hps alt-edited\">Voici un</span> <span class=\"hps\">mur d\'images</span> <span class=\"hps\">avec des marges</span> <span class=\"hps\">et des coins arrondis</span> qui utilise les Widget Spotlight et Lightbox.</p>\r\n<p>[widgetkit id=23]</p>\r\n<h2>Slideset Example</h2>\r\n<p>Cette <span class=\"hps\">galerie d\'images</span> <span class=\"hps\">utilise</span> <span class=\"hps\">toutes les fonctionnalités</span> <span class=\"hps\">du widget</span> Slideset widget.</p>\r\n<p>[widgetkit id=44]</p>\r\n<h2>Comment l\'utiliser ?</h2>\r\n<p class=\"hps\">Le Widgetkit Gallery <span class=\"hps\">est livré avec une</span> <span class=\"hps\">interface d\'administration conviviale</span> <span class=\"hps\">qui permet de modifier ou de </span><span class=\"hps\">créez</span> <span class=\"hps\">de nouvelles galeries</span> en quelques clics. <span class=\"hps\">Le</span> <span class=\"hps\">navigateur</span> <span class=\"hps\">intégré</span> <span class=\"hps\">vous permet d\'ajouter </span><span class=\"hps\">ou de supprimer facilement </span><span class=\"hps\">des répertoires</span> <span class=\"hps\">d\'</span><span class=\"hps\">images.</span> Toute les galeries <span class=\"hps\"><span class=\"hps\">peuvent être chargées</span> <span class=\"hps\">n\'importe où sur votre</span> <span class=\"hps\">site web en utilisant</span> <span class=\"hps\">des numéros courts</span> (p.ex : widgetkit id=23 entre crochet) <span class=\"hps\">ou</span> en utilisant <span class=\"hps\">le module W</span><span class=\"hps\">idgetkit</span> <span class=\"hps\">Joomla</span><span class=\"hps\"></span><span class=\"hps\">.</span></span></p>', '', '1', '0', '0', '2', '2011-07-31 16:30:30', '42', '', '2012-03-07 15:13:43', '0', '0', '0000-00-00 00:00:00', '2011-07-31 16:30:30', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '1', '0', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
CREATE TABLE `canob_content_frontpage` (   `content_id` int(11) NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`content_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `canob_content_frontpage`  VALUES ('29', '5'), ('27', '4'), ('30', '8'), ('31', '9'), ('28', '6'), ('25', '7'), ('24', '2'), ('26', '3'), ('23', '1');
CREATE TABLE `canob_content_rating` (   `content_id` int(11) NOT NULL DEFAULT '0',   `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',   `rating_count` int(10) unsigned NOT NULL DEFAULT '0',   `lastip` varchar(50) NOT NULL DEFAULT '',   PRIMARY KEY (`content_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_core_log_searches` (   `search_term` varchar(128) NOT NULL DEFAULT '',   `hits` int(10) unsigned NOT NULL DEFAULT '0' ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_extensions` (   `extension_id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(100) NOT NULL,   `type` varchar(20) NOT NULL,   `element` varchar(100) NOT NULL,   `folder` varchar(100) NOT NULL,   `client_id` tinyint(3) NOT NULL,   `enabled` tinyint(3) NOT NULL DEFAULT '1',   `access` int(10) unsigned DEFAULT NULL,   `protected` tinyint(3) NOT NULL DEFAULT '0',   `manifest_cache` text NOT NULL,   `params` text NOT NULL,   `custom_data` text NOT NULL,   `system_data` text NOT NULL,   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) DEFAULT '0',   `state` int(11) DEFAULT '0',   PRIMARY KEY (`extension_id`),   KEY `element_clientid` (`element`,`client_id`),   KEY `element_folder_clientid` (`element`,`folder`,`client_id`),   KEY `extension` (`type`,`element`,`folder`,`client_id`) ) ENGINE=MyISAM AUTO_INCREMENT=10032 DEFAULT CHARSET=utf8;
INSERT INTO `canob_extensions`  VALUES ('1', 'com_mailto', 'component', 'com_mailto', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_mailto\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MAILTO_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('2', 'com_wrapper', 'component', 'com_wrapper', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('3', 'com_admin', 'component', 'com_admin', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('4', 'com_banners', 'component', 'com_banners', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('5', 'com_cache', 'component', 'com_cache', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('6', 'com_categories', 'component', 'com_categories', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('7', 'com_checkin', 'component', 'com_checkin', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"Unknown\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2008 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('8', 'com_contact', 'component', 'com_contact', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"show_contact_list\":\"0\",\"presentation_style\":\"sliders\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_misc\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('9', 'com_cpanel', 'component', 'com_cpanel', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10', 'com_installer', 'component', 'com_installer', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `canob_extensions`  VALUES ('11', 'com_languages', 'component', 'com_languages', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"fr-FR\",\"site\":\"fr-FR\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('12', 'com_login', 'component', 'com_login', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('13', 'com_media', 'component', 'com_media', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\",\"enable_flash\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('14', 'com_menus', 'component', 'com_menus', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('15', 'com_messages', 'component', 'com_messages', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('16', 'com_modules', 'component', 'com_modules', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('17', 'com_newsfeeds', 'component', 'com_newsfeeds', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_word_count\":\"0\",\"show_headings\":\"1\",\"show_name\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"display_num\":\"\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\",\"show_cat_items\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('18', 'com_plugins', 'component', 'com_plugins', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('19', 'com_search', 'component', 'com_search', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_SEARCH_XML_DESCRIPTION\",\"group\":\"\"}', '{\"enabled\":\"0\",\"show_date\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('20', 'com_templates', 'component', 'com_templates', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `canob_extensions`  VALUES ('21', 'com_weblinks', 'component', 'com_weblinks', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_weblinks\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"target\":\"0\",\"count_clicks\":\"1\",\"icons\":1,\"link_icons\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_num_links\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_links_cat\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_link_description\":\"1\",\"show_link_hits\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_feed_link\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('22', 'com_content', 'component', 'com_content', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"1\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_vote\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"1\",\"readmore_limit\":\"100\",\"show_icons\":\"1\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"1\",\"show_noauth\":\"0\",\"urls_position\":\"0\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"show_urls_images_frontend\":\"1\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"right\",\"float_fulltext\":\"right\",\"category_layout\":\"_:blog\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"0\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('23', 'com_config', 'component', 'com_config', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"filters\":{\"1\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('24', 'com_redirect', 'component', 'com_redirect', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('25', 'com_users', 'component', 'com_users', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"1\",\"useractivation\":\"1\",\"mail_to_admin\":\"0\",\"captcha\":\"recaptcha\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('27', 'com_finder', 'component', 'com_finder', '', '1', '1', '0', '0', '', '{\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_advanced\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stemmer\":\"porter_en\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('28', 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"February 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.2\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('100', 'PHPMailer', 'library', 'phpmailer', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"PHPMailer\",\"type\":\"library\",\"creationDate\":\"2001\",\"author\":\"PHPMailer\",\"copyright\":\"(c) 2001-2003, Brent R. Matzelle, (c) 2004-2009, Andy Prevost. All Rights Reserved., (c) 2010-2011, Jim Jagielski. All Rights Reserved.\",\"authorEmail\":\"jimjag@gmail.com\",\"authorUrl\":\"https:\\/\\/code.google.com\\/a\\/apache-extras.org\\/p\\/phpmailer\\/\",\"version\":\"5.2\",\"description\":\"LIB_PHPMAILER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('101', 'SimplePie', 'library', 'simplepie', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"SimplePie\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"SimplePie\",\"copyright\":\"Copyright (c) 2004-2009, Ryan Parman and Geoffrey Sneddon\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/simplepie.org\\/\",\"version\":\"1.2\",\"description\":\"LIB_SIMPLEPIE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('102', 'phputf8', 'library', 'phputf8', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"phputf8\",\"type\":\"library\",\"creationDate\":\"2006\",\"author\":\"Harry Fuecks\",\"copyright\":\"Copyright various authors\",\"authorEmail\":\"hfuecks@gmail.com\",\"authorUrl\":\"http:\\/\\/sourceforge.net\\/projects\\/phputf8\",\"version\":\"0.5\",\"description\":\"LIB_PHPUTF8_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `canob_extensions`  VALUES ('103', 'Joomla! Platform', 'library', 'joomla', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"Joomla! Platform\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"http:\\/\\/www.joomla.org\",\"version\":\"11.4\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('200', 'mod_articles_archive', 'module', 'mod_articles_archive', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters.\\n\\t\\tAll rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('201', 'mod_articles_latest', 'module', 'mod_articles_latest', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('202', 'mod_articles_popular', 'module', 'mod_articles_popular', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('203', 'mod_banners', 'module', 'mod_banners', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('204', 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('205', 'mod_custom', 'module', 'mod_custom', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('206', 'mod_feed', 'module', 'mod_feed', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('207', 'mod_footer', 'module', 'mod_footer', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('208', 'mod_login', 'module', 'mod_login', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `canob_extensions`  VALUES ('209', 'mod_menu', 'module', 'mod_menu', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('210', 'mod_articles_news', 'module', 'mod_articles_news', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('211', 'mod_random_image', 'module', 'mod_random_image', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('212', 'mod_related_items', 'module', 'mod_related_items', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('213', 'mod_search', 'module', 'mod_search', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_SEARCH_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('214', 'mod_stats', 'module', 'mod_stats', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('215', 'mod_syndicate', 'module', 'mod_syndicate', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('216', 'mod_users_latest', 'module', 'mod_users_latest', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('217', 'mod_weblinks', 'module', 'mod_weblinks', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_weblinks\",\"type\":\"module\",\"creationDate\":\"July 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('218', 'mod_whosonline', 'module', 'mod_whosonline', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `canob_extensions`  VALUES ('219', 'mod_wrapper', 'module', 'mod_wrapper', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('220', 'mod_articles_category', 'module', 'mod_articles_category', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('221', 'mod_articles_categories', 'module', 'mod_articles_categories', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('222', 'mod_languages', 'module', 'mod_languages', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('223', 'mod_finder', 'module', 'mod_finder', '', '0', '1', '0', '0', '', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('300', 'mod_custom', 'module', 'mod_custom', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('301', 'mod_feed', 'module', 'mod_feed', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('302', 'mod_latest', 'module', 'mod_latest', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('303', 'mod_logged', 'module', 'mod_logged', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('304', 'mod_login', 'module', 'mod_login', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `canob_extensions`  VALUES ('305', 'mod_menu', 'module', 'mod_menu', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('307', 'mod_popular', 'module', 'mod_popular', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('308', 'mod_quickicon', 'module', 'mod_quickicon', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('309', 'mod_status', 'module', 'mod_status', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_status\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_STATUS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('310', 'mod_submenu', 'module', 'mod_submenu', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('311', 'mod_title', 'module', 'mod_title', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('312', 'mod_toolbar', 'module', 'mod_toolbar', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('313', 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"cache\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('314', 'mod_version', 'module', 'mod_version', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('400', 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_authentication_gmail\",\"type\":\"plugin\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_GMAIL_XML_DESCRIPTION\",\"group\":\"\"}', '{\"applysuffix\":\"0\",\"suffix\":\"\",\"verifypeer\":\"1\",\"user_blacklist\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0');
INSERT INTO `canob_extensions`  VALUES ('401', 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_AUTH_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('402', 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('404', 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"mode\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('405', 'plg_content_geshi', 'plugin', 'geshi', 'content', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_geshi\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"qbnz.com\\/highlighter\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_GESHI_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('406', 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"style\":\"none\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('407', 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('408', 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\"}', '{\"position\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '5', '0'), ('409', 'plg_content_vote', 'plugin', 'vote', 'content', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '6', '0'), ('410', 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"linenumbers\":\"0\",\"tabmode\":\"indent\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('411', 'plg_editors_none', 'plugin', 'none', 'editors', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Unknown\",\"copyright\":\"\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"\",\"version\":\"2.5.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0');
INSERT INTO `canob_extensions`  VALUES ('412', 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2012\",\"author\":\"Moxiecode Systems AB\",\"copyright\":\"Moxiecode Systems AB\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"tinymce.moxiecode.com\\/\",\"version\":\"3.5.4.1\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\"}', '{\"mode\":\"1\",\"skin\":\"0\",\"compressed\":\"0\",\"cleanup_startup\":\"0\",\"cleanup_save\":\"2\",\"entity_encoding\":\"raw\",\"lang_mode\":\"0\",\"lang_code\":\"en\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"extended_elements\":\",@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight]\",\"toolbar\":\"top\",\"toolbar_align\":\"left\",\"html_height\":\"550\",\"html_width\":\"750\",\"element_path\":\"1\",\"fonts\":\"1\",\"paste\":\"1\",\"searchreplace\":\"1\",\"insertdate\":\"1\",\"format_date\":\"%Y-%m-%d\",\"inserttime\":\"1\",\"format_time\":\"%H:%M:%S\",\"colors\":\"1\",\"table\":\"1\",\"smilies\":\"1\",\"media\":\"1\",\"hr\":\"1\",\"directionality\":\"1\",\"fullscreen\":\"1\",\"style\":\"1\",\"layer\":\"1\",\"xhtmlxtras\":\"1\",\"visualchars\":\"1\",\"nonbreaking\":\"1\",\"template\":\"1\",\"blockquote\":\"1\",\"wordcount\":\"1\",\"advimage\":\"1\",\"advlink\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"inlinepopups\":\"1\",\"safari\":\"0\",\"custom_plugin\":\"\",\"custom_button\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('413', 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('414', 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('415', 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('416', 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('417', 'plg_search_categories', 'plugin', 'categories', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('418', 'plg_search_contacts', 'plugin', 'contacts', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_CONTACTS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('419', 'plg_search_content', 'plugin', 'content', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('420', 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('421', 'plg_search_weblinks', 'plugin', 'weblinks', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_weblinks\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `canob_extensions`  VALUES ('422', 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('423', 'plg_system_p3p', 'plugin', 'p3p', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_p3p\",\"type\":\"plugin\",\"creationDate\":\"September 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_P3P_XML_DESCRIPTION\",\"group\":\"\"}', '{\"headers\":\"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM\"}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('424', 'plg_system_cache', 'plugin', 'cache', 'system', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', '', '0', '0000-00-00 00:00:00', '9', '0'), ('425', 'plg_system_debug', 'plugin', 'debug', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('426', 'plg_system_log', 'plugin', 'log', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '5', '0'), ('427', 'plg_system_redirect', 'plugin', 'redirect', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '6', '0'), ('428', 'plg_system_remember', 'plugin', 'remember', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '7', '0'), ('429', 'plg_system_sef', 'plugin', 'sef', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '8', '0'), ('430', 'plg_system_logout', 'plugin', 'logout', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('431', 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0');
INSERT INTO `canob_extensions`  VALUES ('432', 'plg_user_joomla', 'plugin', 'joomla', 'user', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2009 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"autoregister\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('433', 'plg_user_profile', 'plugin', 'profile', 'user', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('434', 'plg_extension_joomla', 'plugin', 'joomla', 'extension', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('435', 'plg_content_joomla', 'plugin', 'joomla', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('436', 'plg_system_languagecode', 'plugin', 'languagecode', 'system', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '10', '0'), ('437', 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('438', 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('439', 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"public_key\":\"6LdCd84SAAAAAL7VhLlyN1ltNOLIWir34SE5nHZE \",\"private_key\":\"6LdCd84SAAAAAAmCeqSlvdV6E5PoESQ5ofVs0F2Y\",\"theme\":\"clean\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('440', 'plg_system_highlight', 'plugin', 'highlight', 'system', '0', '1', '1', '0', '', '{}', '', '', '0', '0000-00-00 00:00:00', '7', '0'), ('441', 'plg_content_finder', 'plugin', 'finder', 'content', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"1.7.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `canob_extensions`  VALUES ('442', 'plg_finder_categories', 'plugin', 'categories', 'finder', '0', '1', '1', '0', '', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('443', 'plg_finder_contacts', 'plugin', 'contacts', 'finder', '0', '1', '1', '0', '', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('444', 'plg_finder_content', 'plugin', 'content', 'finder', '0', '1', '1', '0', '', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('445', 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', '0', '1', '1', '0', '', '{}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('446', 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', '0', '1', '1', '0', '', '{}', '', '', '0', '0000-00-00 00:00:00', '5', '0'), ('500', 'atomic', 'template', 'atomic', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"atomic\",\"type\":\"template\",\"creationDate\":\"10\\/10\\/09\",\"author\":\"Ron Severdia\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"contact@kontentdesign.com\",\"authorUrl\":\"http:\\/\\/www.kontentdesign.com\",\"version\":\"2.5.0\",\"description\":\"TPL_ATOMIC_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('502', 'bluestork', 'template', 'bluestork', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"bluestork\",\"type\":\"template\",\"creationDate\":\"07\\/02\\/09\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"TPL_BLUESTORK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"useRoundedCorners\":\"1\",\"showSiteName\":\"0\",\"textBig\":\"0\",\"highContrast\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('503', 'beez_20', 'template', 'beez_20', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"beez_20\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"2.5.0\",\"description\":\"TPL_BEEZ2_XML_DESCRIPTION\",\"group\":\"\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('504', 'hathor', 'template', 'hathor', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"hathor\",\"type\":\"template\",\"creationDate\":\"May 2010\",\"author\":\"Andrea Tarr\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"hathor@tarrconsulting.com\",\"authorUrl\":\"http:\\/\\/www.tarrconsulting.com\",\"version\":\"2.5.0\",\"description\":\"TPL_HATHOR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"showSiteName\":\"0\",\"colourChoice\":\"0\",\"boldText\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('505', 'beez5', 'template', 'beez5', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"beez5\",\"type\":\"template\",\"creationDate\":\"21 May 2010\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"2.5.0\",\"description\":\"TPL_BEEZ5_XML_DESCRIPTION\",\"group\":\"\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"html5\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `canob_extensions`  VALUES ('600', 'English (United Kingdom)', 'language', 'en-GB', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"English (United Kingdom)\",\"type\":\"language\",\"creationDate\":\"2008-03-15\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.5\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('601', 'English (United Kingdom)', 'language', 'en-GB', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"English (United Kingdom)\",\"type\":\"language\",\"creationDate\":\"2008-03-15\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.5\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('700', 'files_joomla', 'file', 'joomla', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"September 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.7\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10000', 'yoo_nano', 'template', 'yoo_nano', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"yoo_nano\",\"type\":\"template\",\"creationDate\":\"May 2011\",\"author\":\"YOOtheme\",\"copyright\":\"Copyright (C) 2007 - 2011 YOOtheme GmbH\",\"authorEmail\":\"info@yootheme.com\",\"authorUrl\":\"http:\\/\\/www.yootheme.com\",\"version\":\"1.0.0\",\"description\":\"Nano is the May 2011 theme of the YOOtheme club. It is based on YOOtheme\'s Warp theme framework. NOTE: It is not free or public. This theme is for members of the YOOtheme club only.\",\"group\":\"\"}', '{\"config\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10001', 'Widgetkit', 'module', 'mod_widgetkit', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"Widgetkit\",\"type\":\"module\",\"creationDate\":\"May 2011\",\"author\":\"YOOtheme\",\"copyright\":\"Copyright (C) 2007 - 2011 YOOtheme GmbH\",\"authorEmail\":\"info@yootheme.com\",\"authorUrl\":\"http:\\/\\/www.yootheme.com\",\"version\":\"1.0.0\",\"description\":\"Widgetkit module for Widgetkit developed by YOOtheme (http:\\/\\/www.yootheme.com)\",\"group\":\"\"}', '{\"widget_id\":\"\",\"moduleclass_sfx\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10002', 'Widgetkit Twitter', 'module', 'mod_widgetkit_twitter', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"Widgetkit Twitter\",\"type\":\"module\",\"creationDate\":\"May 2011\",\"author\":\"YOOtheme\",\"copyright\":\"Copyright (C) 2007 - 2011 YOOtheme GmbH\",\"authorEmail\":\"info@yootheme.com\",\"authorUrl\":\"http:\\/\\/www.yootheme.com\",\"version\":\"1.0.0\",\"description\":\"Twitter module for Widgetkit developed by YOOtheme (http:\\/\\/www.yootheme.com)\",\"group\":\"\"}', '{\"style\":\"list\",\"from_user\":\"\",\"to_user\":\"\",\"ref_user\":\"\",\"hashtag\":\"\",\"word\":\"\",\"nots\":\"\",\"limit\":\"5\",\"image_size\":\"48\",\"show_image\":\"1\",\"show_author\":\"1\",\"show_date\":\"1\",\"moduleclass_sfx\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10003', 'System - Widgetkit', 'plugin', 'widgetkit_system', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"System - Widgetkit\",\"type\":\"plugin\",\"creationDate\":\"May 2011\",\"author\":\"YOOtheme\",\"copyright\":\"Copyright (C) 2007 - 2011 YOOtheme GmbH\",\"authorEmail\":\"info@yootheme.com\",\"authorUrl\":\"http:\\/\\/www.yootheme.com\",\"version\":\"1.0.0\",\"description\":\"Plugin for Widgetkit developed by YOOtheme (http:\\/\\/www.yootheme.com)\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10004', 'Content - Widgetkit', 'plugin', 'widgetkit_content', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Content - Widgetkit\",\"type\":\"plugin\",\"creationDate\":\"May 2011\",\"author\":\"YOOtheme\",\"copyright\":\"Copyright (C) 2007 - 2011 YOOtheme GmbH\",\"authorEmail\":\"info@yootheme.com\",\"authorUrl\":\"http:\\/\\/www.yootheme.com\",\"version\":\"1.0.0\",\"description\":\"Plugin for Widgetkit developed by YOOtheme (http:\\/\\/www.yootheme.com)\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10005', 'widgetkit', 'component', 'com_widgetkit', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"Widgetkit\",\"type\":\"component\",\"creationDate\":\"May 2013\",\"author\":\"YOOtheme\",\"copyright\":\"Copyright (C) YOOtheme GmbH\",\"authorEmail\":\"info@yootheme.com\",\"authorUrl\":\"http:\\/\\/www.yootheme.com\",\"version\":\"1.4.4\",\"description\":\"Widgetkit - A widget toolkit by YOOtheme (http:\\/\\/www.yootheme.com)\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10006', 'PKG_JOOMLA', 'package', 'pkg_joomla', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"PKG_JOOMLA\",\"type\":\"package\",\"creationDate\":\"2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"http:\\/\\/www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PKG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `canob_extensions`  VALUES ('10007', 'System - Widgetkit ZOO', 'plugin', 'widgetkit_zoo', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"System - Widgetkit ZOO\",\"type\":\"plugin\",\"creationDate\":\"June 2011\",\"author\":\"YOOtheme\",\"copyright\":\"Copyright (C) 2007 - 2011 YOOtheme GmbH\",\"authorEmail\":\"info@yootheme.com\",\"authorUrl\":\"http:\\/\\/www.yootheme.com\",\"version\":\"1.0.0\",\"description\":\"ZOO plugin for Widgetkit developed by YOOtheme (http:\\/\\/www.yootheme.com)\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10008', 'System - Widgetkit Joomla', 'plugin', 'widgetkit_joomla', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"System - Widgetkit Joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"YOOtheme\",\"copyright\":\"Copyright (C) 2007 - 2011 YOOtheme GmbH\",\"authorEmail\":\"info@yootheme.com\",\"authorUrl\":\"http:\\/\\/www.yootheme.com\",\"version\":\"1.0.0\",\"description\":\"Joomla Content plugin for Widgetkit developed by YOOtheme (http:\\/\\/www.yootheme.com)\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10009', 'Frenchfr-FR', 'language', 'fr-FR', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"French (fr-FR)\",\"type\":\"language\",\"creationDate\":\"19 mar 2013\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"Copyright (C) 2005 - 2013 joomla.fr et Open Source Matters. Tous droits r\\u00e9serv\\u00e9s\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"2.5.11.1\",\"description\":\"fr-FR site language\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10010', 'Frenchfr-FR', 'language', 'fr-FR', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"French (fr-FR)\",\"type\":\"language\",\"creationDate\":\"19 mar 2013\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"Copyright (C) 2005 - 2013 joomla.fr et Open Source Matters. Tous droits r\\u00e9serv\\u00e9s\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"2.5.11.1\",\"description\":\"fr-FR administrator language\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10011', 'TinyMCE langue FR', 'file', 'TinyMCE_fr-FR', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"TinyMCE langue FR\",\"type\":\"file\",\"creationDate\":\"4 feb 2013\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"(C) 2005-2013 French Translation Team\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"3.5.4.1\",\"description\":\"\\t\\t\\n\\t\\t<h3>Installation du pack de langue FR de TinyMCE 3.5.4.1 pour Joomla 2.5 effectu\\u00e9e avec succ\\u00e8s<\\/h3>\\n \\u00a0 \\u00a0 \\u00a0 \\u00a0<div style=\\\"font-weight:normal\\\">\\n \\t\\tN\'oubliez pas de s\\u00e9lectionner la langue FR dans la \\n \\t\\t<a href=\\\"index.php?option=com_plugins&view=plugins&filter_search=TinyMCE\\\"><strong>gestion du plug-in TinyMCE<\\/strong><\\/a><br \\/>\\n \\t\\tSi vous utilisez la d\\u00e9tection automatique, veillez \\u00e0 ce que soient install\\u00e9s les diff\\u00e9rents packs de langue de TinyMCE correspondants \\n \\t\\t\\u00e0 ceux install\\u00e9s pour Joomla!<\\/div>\\t\\t\\n\\t\\t\\n\\t\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10012', 'fr-FR', 'package', 'pkg_fr-FR', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"French Language Pack\",\"type\":\"package\",\"creationDate\":\"19 mar 2013\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"Copyright (C) 2005 - 2013 joomla.fr et Open Source Matters. Tous droits r\\u00e9serv\\u00e9s\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"2.5.11.1\",\"description\":\"\\n\\t\\t\\n\\t\\t<h3>Joomla! Full French (fr-FR) Language Package version 2.5.11v1<\\/h3>\\n\\t\\t<h3>Paquet de langue fran\\u00e7ais complet Joomla! fr-FR version 2.5.11v1<\\/h3>\\n\\t\\t<div>Installation inclue du pack de langue fr-FR de TinyMCE 3.5.4 pour Joomla 2.5.11<\\/div><br>\\n\\t\\t<div style=\\\"font-weight: normal; padding-bottom:15px;\\\">N\'oubliez pas de s\\u00e9lectionner la langue FR dans les <a href=\\\"index.php?option=com_plugins&amp;view=plugins&amp;filter_search=TinyMCE\\\"><strong>param\\u00e8tres du plug-in \'\\u00c9diteur - TinyMCE\'<\\/strong><\\/a> (param\\u00e8tre  \'Langue de l\'\\u00e9diteur\' = fr).<br>\\n \\t\\tSi vous utilisez la <strong>d\\u00e9tection automatique<\\/strong>, veillez \\u00e0 ce que soient install\\u00e9s les diff\\u00e9rents packs de langue de TinyMCE correspondants aux packs de langue install\\u00e9s pour Joomla!<\\/div>\\n\\t\\t\\n\\t\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10013', 'GermanDE-CH-AT', 'language', 'de-DE', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"German (DE-CH-AT)\",\"type\":\"language\",\"creationDate\":\"13.09.2012\",\"author\":\"J!German\",\"copyright\":\"Copyright (C) 2008 - 2012 J!German. All rights reserved.\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"http:\\/\\/www.jgerman.de\",\"version\":\"2.5.7.1\",\"description\":\"\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"German (Deutsch)\\\" src=\\\"data:;base64,R0lGODlhEgAMAJEAAP\\/OAAAAAN0AAAAAACH5BAAAAAAALAAAAAASAAwAAAIXjI+py+2vhJy02ouz3hb4D4biSJbmKRYAOw==\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>Deutsche Frontend (Website)-\\u00dcbersetzung f\\u00fcr Joomla! 2.5.7\\n      <br \\/>\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"English (Englisch)\\\" src=\\\"data:image\\/gif;base64,R0lGODlhEgAMAPcAANQYLe+nr+iPmgElcdQuQtQtQtq\\/zc8UK88TKu2Sm+A4SOucpn2RvxIseCBLmRIpdtIWLAEkctAUK\\/\\/f3g4tguqXodozRcwDHNa8y8fT5h9GlP\\/7+R82fcwIIPOCiRg2fwc0fP\\/6+AEohAwqgffV2QYuhfaTmQApgi1VngAZd9Y0SOmTnaysytIjOPixtbZlgOxVYehUYPbP09FqfWByq\\/XL0BIndO2Fju6AieZ8iQAaed9gcOnm7t28wgEpdImUt2B\\/uOtWYsAPHP\\/o5t5SYdzs98pwd\\/KXn\\/\\/v7tjo9WRyqXBtkgEdbPbu8c0MJHdomvB4gHBglMwGH7Nphm6Zy9Pq6uufqfjh5NUwRM8SKhIqd9c5TNc4TNUxRRIjcxAvg9FpfPCmpiBOjv\\/r6cYgKhIfb\\/\\/i4fSTmdm+zClSnOiMl+dXY1RioK5kgxg5hPOZoNMpPmh\\/tTxalmqFut\\/G0tchLdni765RcOiOmQAgfcHZ7v77+3J4o+6UnfTKz\\/\\/\\/\\/OurtYScx66wzThepMy7vwAeeiJLmumQmv\\/m5QAceN00RmOBqgEnc9zr9+lWY+qWoNY0Rw80eudUYWZ1qytZk+unsAYxiup5g+iSnX6Ww7Vif9EQH\\/Df5dbc6hIqdt3w+\\/\\/q6MwFHfOLkuj6\\/+ylrgAVde+aotPQ3+yMls8VLNbc69+lo+6nr9tHWAAPcLTI480GHssAGf\\/\\/\\/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAASAAwAAAjoAH9wKPOggZYPPepsCiPHRgNPXtzwGVKEwZdShUoYAAArAIpEKSwp0RTDERREjRiMyIOGYwAHIia9kORhApspRC6NsZOJDgRYlQK1WYODxKc5gjJcYeUnxB8ZCKRYQeKihqw9p1goUNRlC6QCBOAcyNICCxcVBApYUBCrrdtYFw6k6vDW7RsBAlYsqJAgBwInO\\/ocwvNoAaYjQPTIkmXKBA9OEkIBGiVrg5oEqqi8aoIqyIwoGjBwJDWIRiczN1rdOQMDzBNDOk5s7JjGFYU4SUCJMrJETIQBPkAQIiNkFaUBjJhEWlQlIAA7\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>German Frontend (Website) translation for Joomla! 2.5.7\\n    \",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10014', 'GermanDE-CH-AT', 'language', 'de-DE', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"German (DE-CH-AT)\",\"type\":\"language\",\"creationDate\":\"13.09.2012\",\"author\":\"J!German\",\"copyright\":\"Copyright (C) 2008 - 2012 J!German. All rights reserved.\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"http:\\/\\/www.jgerman.de\",\"version\":\"2.5.7.1\",\"description\":\"\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"German (Deutsch)\\\" src=\\\"data:;base64,R0lGODlhEgAMAJEAAP\\/OAAAAAN0AAAAAACH5BAAAAAAALAAAAAASAAwAAAIXjI+py+2vhJy02ouz3hb4D4biSJbmKRYAOw==\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>Deutsche Backend (Administrator)-\\u00dcbersetzung f\\u00fcr Joomla! 2.5.7\\n      <br \\/>\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"English (Englisch)\\\" src=\\\"data:image\\/gif;base64,R0lGODlhEgAMAPcAANQYLe+nr+iPmgElcdQuQtQtQtq\\/zc8UK88TKu2Sm+A4SOucpn2RvxIseCBLmRIpdtIWLAEkctAUK\\/\\/f3g4tguqXodozRcwDHNa8y8fT5h9GlP\\/7+R82fcwIIPOCiRg2fwc0fP\\/6+AEohAwqgffV2QYuhfaTmQApgi1VngAZd9Y0SOmTnaysytIjOPixtbZlgOxVYehUYPbP09FqfWByq\\/XL0BIndO2Fju6AieZ8iQAaed9gcOnm7t28wgEpdImUt2B\\/uOtWYsAPHP\\/o5t5SYdzs98pwd\\/KXn\\/\\/v7tjo9WRyqXBtkgEdbPbu8c0MJHdomvB4gHBglMwGH7Nphm6Zy9Pq6uufqfjh5NUwRM8SKhIqd9c5TNc4TNUxRRIjcxAvg9FpfPCmpiBOjv\\/r6cYgKhIfb\\/\\/i4fSTmdm+zClSnOiMl+dXY1RioK5kgxg5hPOZoNMpPmh\\/tTxalmqFut\\/G0tchLdni765RcOiOmQAgfcHZ7v77+3J4o+6UnfTKz\\/\\/\\/\\/OurtYScx66wzThepMy7vwAeeiJLmumQmv\\/m5QAceN00RmOBqgEnc9zr9+lWY+qWoNY0Rw80eudUYWZ1qytZk+unsAYxiup5g+iSnX6Ww7Vif9EQH\\/Df5dbc6hIqdt3w+\\/\\/q6MwFHfOLkuj6\\/+ylrgAVde+aotPQ3+yMls8VLNbc69+lo+6nr9tHWAAPcLTI480GHssAGf\\/\\/\\/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAASAAwAAAjoAH9wKPOggZYPPepsCiPHRgNPXtzwGVKEwZdShUoYAAArAIpEKSwp0RTDERREjRiMyIOGYwAHIia9kORhApspRC6NsZOJDgRYlQK1WYODxKc5gjJcYeUnxB8ZCKRYQeKihqw9p1goUNRlC6QCBOAcyNICCxcVBApYUBCrrdtYFw6k6vDW7RsBAlYsqJAgBwInO\\/ocwvNoAaYjQPTIkmXKBA9OEkIBGiVrg5oEqqi8aoIqyIwoGjBwJDWIRiczN1rdOQMDzBNDOk5s7JjGFYU4SUCJMrJETIQBPkAQIiNkFaUBjJhEWlQlIAA7\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>German Backend (Administrator) translation for Joomla! 2.5.7\\n    \",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10015', 'de-DE', 'package', 'pkg_de-DE', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"German Language Pack\",\"type\":\"package\",\"creationDate\":\"13.09.2012\",\"author\":\"J!German\",\"copyright\":\"\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"http:\\/\\/www.jgerman.de\",\"version\":\"2.5.7.1\",\"description\":\"\\n    <div style=\\\"text-align: center;\\\">\\n      <h2>Deutsches \\u201eFull\\u201c-Sprachpaket f\\u00fcr Joomla! 2.5.7 von <a title=\\\"J!German\\\" href=\\\"http:\\/\\/www.jgerman.de\\\" target=\\\"_blank\\\">J!German<\\/a><\\/h2>\\n      <h3><span style=\\\"color: #008000;\\\">\\u00dcbersetzungsversion: 2.5.7v1<\\/span><\\/h3>\\n      <hr \\/>\\n      <table rules=\\\"all\\\" frame=\\\"border\\\" style=\\\"width: 90%; border-color: #000000; border-width: 1px; border-style: solid;\\\" align=\\\"center\\\" border=\\\"1\\\">\\n      <colgroup> <col width=\\\"30%\\\" \\/> <col width=\\\"60\\\" \\/> <\\/colgroup>\\n      <tbody>\\n        <tr>\\n          <td>\\n            <ul>\\n              <li>Frontend (Website)-\\u00dcbersetzung<\\/li>\\n            <\\/ul>\\n          <\\/td>\\n          <td rowspan=\\\"2\\\">\\n            <ul>\\n              <li>\\n                <span style=\\\"text-decoration: underline;\\\">Neuinstallation:<\\/span>\\n                <br \\/>\\n                Legen Sie die deutsche Sprache unter <a title=\\\"Language Manager\\\" href=\\\"index.php?option=com_languages\\\" target=\\\"_blank\\\">\\u201eExtensions\\u201c \\u2192 \\u201eLanguage Manager\\u201c<\\/a> als Standardsprache (\\u201eDefault\\u201c), sowohl f\\u00fcr die Website (\\u201eInstalled - Site\\u201c) als auch f\\u00fcr die Administration (\\u201eInstalled - Administrator\\u201c), fest.\\n              <\\/li>\\n              <br \\/>\\n              <li>\\n                <span style=\\\"text-decoration: underline;\\\">Aktualisierung:<\\/span>\\n                <br \\/>\\n                Es sind keine weiteren Schritte erforderlich.\\n              <\\/li>\\n            <\\/ul>\\n          <\\/td>\\n        <\\/tr>\\n        <tr>\\n          <td>\\n            <ul>\\n              <li>Backend (Administrator)-\\u00dcbersetzung<\\/li>\\n            <\\/ul>\\n          <\\/td>\\n        <\\/tr>\\n        <tr>\\n          <td>\\n            <ul>\\n              <li>Editor (TinyMCE)-\\u00dcbersetzung<\\/li>\\n            <\\/ul>\\n          <\\/td>\\n          <td>\\n            <ul>\\n              <li>\\n                <span style=\\\"text-decoration: underline;\\\">Neuinstallation:<\\/span>\\n                <br \\/>\\n                Aktivieren Sie in den <a title=\\\"TinyMCE in der Pluginverwaltung\\\" href=\\\"index.php?option=com_plugins&amp;view=plugins&amp;filter_search=TinyMCE\\\" target=\\\"_blank\\\">TinyMCE-Plugineinstellungen<\\/a> die automatische Sprachauswahl auf \\u201eJa\\u201c (\\u201eBasisoptionen\\u201c \\u2192 \\u201eAutom. Sprachauswahl\\u201c).\\n              <\\/li>\\n              <br \\/>\\n              <li>\\n                <span style=\\\"text-decoration: underline;\\\">Aktualisierung (nur wenn vor dieser Installation ein <strong>seperates<\\/strong> TinyMCE-Sprachpaket installiert war):<\\/span>\\n                <br \\/>\\n                Deinstallieren Sie das alte TinyMCE-Sprachpaket \\u00fcber \\u201eErweiterungen\\u201c \\u2192 \\u201eErweiterungen\\u201c \\u2192 \\u201eVerwalten\\u201c \\u2192 \\u201eTinyMCE de-DE\\u201c. Danach installieren Sie dieses Paket erneut.<br \\/>Damit sorgen Sie daf\\u00fcr, dass der alte Aktualisierungsserver f\\u00fcr das einzelne TinyMCE-Sprachpaket aus Joomla! gel\\u00f6scht wird und so bei einer Aktualisierungsanfrage nicht unn\\u00f6tig gepr\\u00fcft wird.\\n              <\\/li>\\n            <\\/ul>\\n          <\\/td>\\n        <\\/tr>\\n      <\\/tbody>\\n      <\\/table>\\n      <br \\/>\\n      <span style=\\\"text-decoration: underline;\\\">Hinweis:<\\/span> Dieses Paket unterst\\u00fctzt die Joomla! eigene <a title=\\\"Joomla!-Aktualisierungsfunktion\\\" href=\\\"index.php?option=com_installer&amp;view=update\\\" target=\\\"_blank\\\">Aktualisierungsfunktion<\\/a>!\\n    <\\/div>\\n    \",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10016', 'Editor - JCE', 'plugin', 'jce', 'editors', '0', '1', '1', '0', '{\"legacy\":true,\"name\":\"Editor - JCE\",\"type\":\"plugin\",\"creationDate\":\"12 September 2012\",\"author\":\"Ryan Demmer\",\"copyright\":\"2006-2010 Ryan Demmer\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"http:\\/\\/www.joomlacontenteditor.net\",\"version\":\"2.2.7.2\",\"description\":\"WF_EDITOR_PLUGIN_DESC\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `canob_extensions`  VALUES ('10017', 'jce', 'component', 'com_jce', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"JCE\",\"type\":\"component\",\"creationDate\":\"12 September 2012\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2012 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"www.joomlacontenteditor.net\",\"version\":\"2.2.7.2\",\"description\":\"WF_ADMIN_DESC\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10018', 'com_phocadownload', 'component', 'com_phocadownload', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"com_phocadownload\",\"type\":\"component\",\"creationDate\":\"07\\/02\\/2012\",\"author\":\"Jan Pavelka (www.phoca.cz)\",\"copyright\":\"Jan Pavelka\",\"authorEmail\":\"\",\"authorUrl\":\"www.phoca.cz\",\"version\":\"2.1.5\",\"description\":\"Phoca Download\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10019', 'plg_editors-xtd_phocadownload', 'plugin', 'phocadownload', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_phocadownload\",\"type\":\"plugin\",\"creationDate\":\"22\\/11\\/2011\",\"author\":\"Jan Pavelka (www.phoca.cz)\",\"copyright\":\"Jan Pavelka\",\"authorEmail\":\"\",\"authorUrl\":\"www.phoca.cz\",\"version\":\"2.1.4\",\"description\":\"PLG_EDITORS-XTD_PHOCADOWNLOAD_DESCRIPTION\",\"group\":\"\"}', '{\"enable_frontend\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10020', 'plg_content_phocadownload', 'plugin', 'phocadownload', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_phocadownload\",\"type\":\"plugin\",\"creationDate\":\"07\\/02\\/2012\",\"author\":\"Jan Pavelka (www.phoca.cz)\",\"copyright\":\"Jan Pavelka\",\"authorEmail\":\"\",\"authorUrl\":\"www.phoca.cz\",\"version\":\"2.1.6\",\"description\":\"PLG_CONTENT_PHOCADOWNLOAD_DESCRIPTION\",\"group\":\"\"}', '{\"icon_size\":\"32\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10021', 'Akeeba Backup Notification Module', 'module', 'mod_akadmin', '', '1', '1', '2', '0', '{\"legacy\":true,\"name\":\"Akeeba Backup Notification Module\",\"type\":\"module\",\"creationDate\":\"2012-03-07\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2009-2010 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"3.4.1\",\"description\":\"\\n\\t<h1>Akeeba Backup Notification Module<\\/h1>\\n\\t<p>This is a handy  module to display a Akeeba icon on your administrator\\n\\tback-end\'s Control Panel page. The icon displays a warning site if the last\\n\\tbackup is failed, or if you haven\'t backed up your site for a period of time\\n\\t(user-defined). Clicking it brings you to the Akeeba Backup &quot;Backup Now&quot;\\n\\tpage.<\\/p>\\n\\t\",\"group\":\"\"}', '[]', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10022', 'Akeeba Backup Lazy Scheduling', 'plugin', 'aklazy', 'system', '0', '0', '1', '0', '{\"legacy\":true,\"name\":\"Akeeba Backup Lazy Scheduling\",\"type\":\"plugin\",\"creationDate\":\"2011-04-17\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2010-2012 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"3.3\",\"description\":\"\\n\\t\\tAutomate your Akeeba Backup installation without using CRON, taking\\n\\t\\tadvantage of your site\'s visitor activity. Important: Read the\\n\\t\\tdocumentation before proceeding. THIS PLUGIN IS NO LONGER SUPPORTED.\\n\\t\\tDO NOT REQUEST SUPPORT IF IT DOESN\'T WORK. READ THE DOCUMENTATION FOR\\n\\t\\tA LIST OF KNOWN ISSUES.\\n\\t\",\"group\":\"\"}', '{\"daysfreq\":\"1\",\"backuptime\":\"00:00\",\"profile\":\"1\",\"@spacer\":\"\",\"test\":\"0\",\"resetpw\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10024', 'akeebabackup-fr-FR', 'file', 'fr-FR', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"akeebabackup-fr-FR\",\"type\":\"file\",\"creationDate\":\"20 Feb 2012\",\"author\":\"AkeebaBackup.com\",\"copyright\":\"Copyright (C)2012 AkeebaBackup.com. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"0.0.20122002132717\",\"description\":\"French (France) translation file for Akeeba Backup\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10025', 'System - JCE MediaBox', 'plugin', 'jcemediabox', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"System - JCE MediaBox\",\"type\":\"plugin\",\"creationDate\":\"06 D\\u00e9cembre 2011\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2011 Ryan Demmer. All rights reserved\",\"authorEmail\":\"@@email@@\",\"authorUrl\":\"www.joomlacontenteditor.net\",\"version\":\"1.1.2\",\"description\":\"\\n\\t<h3>Plugin JCE MediaBox pour l\'\\u00e9diteur JCE<\\/h3>\\n\\t<div style=\\\"font-weight:normal;\\\"><p>Pour utiliser JCE MediaBox, vous devez l\'activer par <a href=\\\"index.php?option=com_plugins&amp;filter_type=system&amp;filter_search=jce%20mediabox\\\" title=\\\"Publish\\\"><strong>ce lien...<\\/strong><\\/a><\\/p>\\n\\t<p>JCE MediaBox permet d\'afficher des m\\u00e9dias (image, flash, flv, quicktime, vmw, avi, mpg, divx, youtube, etc.) et des contenus en popup de styles personnalisables.<br \\/>\\n\\tJCE MediaBox permet \\u00e9galement d\'ins\\u00e9rer des Bulles d\'info (Tooltip) sur du texte ou des m\\u00e9dias.<br \\/>\\n\\tJCE MediaBox offre une fonction de correction des transparences d\'images en PNG24 sous IE6.<\\/p>\\n\\t<p>Bas\\u00e9 et inspir\\u00e9 par...<\\/p>\\n\\t<ul><li>TinyMCE de Moxiecode - http:\\/\\/tinymce.moxiecode.com<\\/li>\\n\\t\\t<li>Th\\u00e8me Lightbox inspir\\u00e9 de Slimbox de Christophe Beyls - http:\\/\\/www.digitalia.be<\\/li>\\n\\t\\t<li>Th\\u00e8me Shadow inspir\\u00e9 de ShadowBox - http:\\/\\/mjijackson.com\\/shadowbox\\/<\\/li>\\n\\t\\t<li>Th\\u00e8me Squeeze inspir\\u00e9 de Squeezebox de Harald Kirschner - http:\\/\\/digitarald.de\\/project\\/squeezebox\\/<\\/li>\\n\\t\\t<li>Th\\u00e8me Thickbox 2.0 de Cody Lindley - http:\\/\\/www.codeylindley.com<\\/li>\\n\\t<\\/ul>\\n\\t<p>Fonctionne avec FF 2+, IE 6+, Opera 9+, Chrome, Safari, Camino, et +<br \\/>Th\\u00e8mes sp\\u00e9ciaux pour iPhone et iPad.<\\/p>\\n\\t<p>Historique des mises \\u00e0 jour : <a href=\\\"http:\\/\\/www.joomlacontenteditor.net\\/support\\/releases\\/changelog\\/jcemediabox\\\" target=\\\"_blank\\\" title=\\\"Changelog\\\">http:\\/\\/www.joomlacontenteditor.net\\/support\\/releases\\/changelog\\/jcemediabox<\\/a><\\/p>\\n\\t<p>Pr\\u00e9sentation, modes d\'emploi et forum en fran\\u00e7ais sur le portail FR : <a href=\\\"http:\\/\\/www.sarki.ch\\/jce\\\" target=\\\"_blank\\\">http:\\/\\/www.sarki.ch\\/jce<\\/a><\\/p><\\/div>\\n\\t\",\"group\":\"\"}', '{\"theme\":\"standard\",\"imgpath\":\"plugins\\/system\\/jcemediabox\\/img\",\"fadespeed\":\"500\",\"scalespeed\":\"500\",\"overlay\":\"1\",\"overlayopacity\":\"0.8\",\"overlaycolor\":\"#000000\",\"width\":\"\",\"height\":\"\",\"resize\":\"1\",\"close\":\"2\",\"icons\":\"1\",\"hideobjects\":\"0\",\"scrolling\":\"fixed\",\"components\":\"\",\"dynamic_themes\":\"0\",\"legacy\":\"0\",\"lightbox\":\"0\",\"shadowbox\":\"0\",\"tipclass\":\"tooltip\",\"tipopacity\":\"0.8\",\"tipspeed\":\"150\",\"tipposition\":\"br\",\"tipoffsets_x\":\"16\",\"tipoffsets_y\":\"16\",\"flash\":\"10,0,22,87\",\"windowsmedia\":\"5,1,52,701\",\"quicktime\":\"6,0,2,0\",\"realmedia\":\"7,0,0,0\",\"shockwave\":\"8,5,1,0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10027', 'Komponente Phoca E-Mail - Deutsche Sprachdateien', 'file', 'de-DE.com_phocaemail', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"Komponente Phoca E-Mail - Deutsche Sprachdateien\",\"type\":\"file\",\"creationDate\":\"20.06.2011\",\"author\":\"JOO!MWEB Webservice Olaf Dryja\",\"copyright\":\"Copyright (C) 2011-2012 - JOOM!WEB Webservice Olaf Dryja. Alle Rechte vorbehalten.\",\"authorEmail\":\"info@joomweb.de\",\"authorUrl\":\"https:\\/\\/joomweb.de\",\"version\":\"2.0.0\",\"description\":\"\\n\\t\\t\\n\\t\\t\\t<p><strong>Sprachdatei f\\u00fcr die Komponente\\/Version:<\\/strong> Phoca E-Mail 2.0.0 (de-DE.com_phocaemail)<br \\/><br \\/>\\n\\t    \\t<strong>Sprache:<\\/strong> Deutsch (formell)<br \\/>\\n\\t    \\t<strong>Bereich:<\\/strong> Administrator - Administrationsbereich (Backend) und Site - Benutzerbereich (Frontend)<br \\/>\\n\\t    \\t<strong>Autor:<\\/strong> JOOM!WEB - Webservice Olaf Dryja <a target=\\\"_blank\\\" href=\\\"https:\\/\\/joomweb.de\\\">joomweb.de<\\/a> f\\u00fcr <a target=\\\"_blank\\\" href=\\\"http:\\/\\/phoca.cz\\\">Phoca.CZ<\\/a>.<br \\/>\\n\\t    \\t<strong>\\u00dcbersetzungsversion:<\\/strong> 2.0.0_2 <br \\/><br \\/>\\n\\t    \\t<strong><font style=\\\"color:#008000;\\\">Bitte \\u00fcberpr\\u00fcfen Sie regelm\\u00e4\\u00dfig unsere Projektseite. Dort erfahren Sie, ob \\u00c4nderungen oder neue Versionen zu dieser \\u00dcbersetzung verf\\u00fcgbar sind.<\\/font><\\/strong>\\n        \\t<\\/p>\\n        \\n        \",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10028', 'lib_fof', 'library', 'lib_fof', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"lib_fof\",\"type\":\"library\",\"creationDate\":\"2012-05-14\",\"author\":\"Nicholas K. Dionysopoulos \\/ AkeebaBackup.com\",\"copyright\":\"(C)2011-2012 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"revF19B2DB\",\"description\":\"Framework-on-Framework (FOF) \\u2013 A rapid component development framework extension for Joomla!\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `canob_extensions`  VALUES ('10029', 'plg_quickicon_jcefilebrowser', 'plugin', 'jcefilebrowser', 'quickicon', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_quickicon_jcefilebrowser\",\"type\":\"plugin\",\"creationDate\":\"April 2012\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2012 Ryan Demmer. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_QUICKICON_JCEFILEBROWSER_XML_DESCRIPTION\",\"group\":\"\"}', '{\"width\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10030', 'akeeba', 'component', 'com_akeeba', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"Akeeba\",\"type\":\"component\",\"creationDate\":\"2012-05-14\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2012 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"3.5.0\",\"description\":\"Akeeba Backup Core - Full Joomla! site backup solution, Core Edition.\",\"group\":\"\"}', '{\"siteurl\":\"http:\\/\\/joomlatest.grangeweb.ch\\/\",\"jlibrariesdir\":\"\\/home\\/httpd\\/vhosts\\/grangeweb.ch\\/subdomains\\/joomlatest\\/httpdocs\\/libraries\",\"jversion\":\"1.6\",\"lastversion\":\"3.5.0\",\"minstability\":\"stable\",\"liveupdate\":\"lastcheck=1337370033\\nupdatedata=\\\"\\\"{\\\\\\\"supported\\\\\\\":true,\\\\\\\"stuck\\\\\\\":false,\\\\\\\"version\\\\\\\":\\\\\\\"3.5.0\\\\\\\",\\\\\\\"date\\\\\\\":\\\\\\\"2012-05-14\\\\\\\",\\\\\\\"stability\\\\\\\":\\\\\\\"stable\\\\\\\",\\\\\\\"downloadURL\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\\\/\\\\\\\\\\\\\\/joomlacode.org\\\\\\\\\\\\\\/gf\\\\\\\\\\\\\\/download\\\\\\\\\\\\\\/frsrelease\\\\\\\\\\\\\\/17063\\\\\\\\\\\\\\/74156\\\\\\\\\\\\\\/com_akeeba-3.5.0-core.zip\\\\\\\",\\\\\\\"infoURL\\\\\\\":\\\\\\\"https:\\\\\\\\\\\\\\/\\\\\\\\\\\\\\/www.akeebabackup.com\\\\\\\\\\\\\\/downloads\\\\\\\\\\\\\\/akeeba-backup\\\\\\\\\\\\\\/akeeba-backup-3-5-0.html\\\\\\\",\\\\\\\"releasenotes\\\\\\\":\\\\\\\"<h3 class=\\\\\\\\\\\\\\\"p1\\\\\\\\\\\\\\\"><span class=\\\\\\\\\\\\\\\"s1\\\\\\\\\\\\\\\">Changelog<\\\\\\\\\\\\\\/span><\\\\\\\\\\\\\\/h3><p><strong>Miscellaneous changes<\\\\\\\\\\\\\\/strong><\\\\\\\\\\\\\\/p><ul><li>Default minimum update stability is now set to stable.<\\\\\\\\\\\\\\/li><li>Akeeba Backup Core always updates to Stable only, irrespective of the user\'s preferences. You can install unstable releases only manually.<\\\\\\\\\\\\\\/li><li>The Post-Installation page now allows you to select the minimum update stability level and warns you if you select alpha, beta or RC.<\\\\\\\\\\\\\\/li><li>Auto-disable the Akeeba Backup icon module if a crash is detected, making sure that failed updates won\'t bring down your site<\\\\\\\\\\\\\\/li><\\\\\\\\\\\\\\/ul><p><strong>Bug fixes<\\\\\\\\\\\\\\/strong><\\\\\\\\\\\\\\/p><ul><li>Accessing Live Update threw a Not Authorized error<\\\\\\\\\\\\\\/li><li>Forgot to include the frontend dispatcher in the XML manifest. Thank you, Daniele!<\\\\\\\\\\\\\\/li><li>The CLI scripts weren\'t copied when installing the Professional release<\\\\\\\\\\\\\\/li><li>The SRP and Update Check plugins wouldn\'t get installed in the Professional release<\\\\\\\\\\\\\\/li><li>The remote API for the SRP backup was broken. Thank you Daniele!<\\\\\\\\\\\\\\/li><li>FOF wasn\'t loaded by mod_akadmin, causing a fatal error to be thrown in the Joomla! control panel<\\\\\\\\\\\\\\/li><li>Front-end backup wasn\'t working properly under certain conditions<\\\\\\\\\\\\\\/li><\\\\\\\\\\\\\\/ul>\\\\\\\"}\\\"\\\"\\nstuck=0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10031', 'TinyMCE de-DE', 'file', 'file_tinymce_de-DE', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"TinyMCE de-DE\",\"type\":\"file\",\"creationDate\":\"13.09.2012\",\"author\":\"J!German\",\"copyright\":\"Copyright (C) 2008 - 2012 J!German. All rights reserved.\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"http:\\/\\/www.jgerman.de\",\"version\":\"2.5.7.1\",\"description\":\"\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"German (Deutsch)\\\" src=\\\"data:;base64,R0lGODlhEgAMAJEAAP\\/OAAAAAN0AAAAAACH5BAAAAAAALAAAAAASAAwAAAIXjI+py+2vhJy02ouz3hb4D4biSJbmKRYAOw==\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>Deutsche Editor (TinyMCE)-\\u00dcbersetzung f\\u00fcr Joomla! 2.5.7\\n      <br \\/>\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"English (Englisch)\\\" src=\\\"data:image\\/gif;base64,R0lGODlhEgAMAPcAANQYLe+nr+iPmgElcdQuQtQtQtq\\/zc8UK88TKu2Sm+A4SOucpn2RvxIseCBLmRIpdtIWLAEkctAUK\\/\\/f3g4tguqXodozRcwDHNa8y8fT5h9GlP\\/7+R82fcwIIPOCiRg2fwc0fP\\/6+AEohAwqgffV2QYuhfaTmQApgi1VngAZd9Y0SOmTnaysytIjOPixtbZlgOxVYehUYPbP09FqfWByq\\/XL0BIndO2Fju6AieZ8iQAaed9gcOnm7t28wgEpdImUt2B\\/uOtWYsAPHP\\/o5t5SYdzs98pwd\\/KXn\\/\\/v7tjo9WRyqXBtkgEdbPbu8c0MJHdomvB4gHBglMwGH7Nphm6Zy9Pq6uufqfjh5NUwRM8SKhIqd9c5TNc4TNUxRRIjcxAvg9FpfPCmpiBOjv\\/r6cYgKhIfb\\/\\/i4fSTmdm+zClSnOiMl+dXY1RioK5kgxg5hPOZoNMpPmh\\/tTxalmqFut\\/G0tchLdni765RcOiOmQAgfcHZ7v77+3J4o+6UnfTKz\\/\\/\\/\\/OurtYScx66wzThepMy7vwAeeiJLmumQmv\\/m5QAceN00RmOBqgEnc9zr9+lWY+qWoNY0Rw80eudUYWZ1qytZk+unsAYxiup5g+iSnX6Ww7Vif9EQH\\/Df5dbc6hIqdt3w+\\/\\/q6MwFHfOLkuj6\\/+ylrgAVde+aotPQ3+yMls8VLNbc69+lo+6nr9tHWAAPcLTI480GHssAGf\\/\\/\\/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAASAAwAAAjoAH9wKPOggZYPPepsCiPHRgNPXtzwGVKEwZdShUoYAAArAIpEKSwp0RTDERREjRiMyIOGYwAHIia9kORhApspRC6NsZOJDgRYlQK1WYODxKc5gjJcYeUnxB8ZCKRYQeKihqw9p1goUNRlC6QCBOAcyNICCxcVBApYUBCrrdtYFw6k6vDW7RsBAlYsqJAgBwInO\\/ocwvNoAaYjQPTIkmXKBA9OEkIBGiVrg5oEqqi8aoIqyIwoGjBwJDWIRiczN1rdOQMDzBNDOk5s7JjGFYU4SUCJMrJETIQBPkAQIiNkFaUBjJhEWlQlIAA7\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>German Editor (TinyMCE) translation for Joomla! 2.5.7\\n    \",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
CREATE TABLE `canob_finder_filters` (   `filter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `title` varchar(255) NOT NULL,   `alias` varchar(255) NOT NULL,   `state` tinyint(1) NOT NULL DEFAULT '1',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL,   `created_by_alias` varchar(255) NOT NULL,   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `map_count` int(10) unsigned NOT NULL DEFAULT '0',   `data` text NOT NULL,   `params` mediumtext,   PRIMARY KEY (`filter_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links` (   `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `url` varchar(255) NOT NULL,   `route` varchar(255) NOT NULL,   `title` varchar(255) DEFAULT NULL,   `description` varchar(255) DEFAULT NULL,   `indexdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `md5sum` varchar(32) DEFAULT NULL,   `published` tinyint(1) NOT NULL DEFAULT '1',   `state` int(5) DEFAULT '1',   `access` int(5) DEFAULT '0',   `language` varchar(8) NOT NULL,   `publish_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `list_price` double unsigned NOT NULL DEFAULT '0',   `sale_price` double unsigned NOT NULL DEFAULT '0',   `type_id` int(11) NOT NULL,   `object` mediumblob NOT NULL,   PRIMARY KEY (`link_id`),   KEY `idx_type` (`type_id`),   KEY `idx_title` (`title`),   KEY `idx_md5` (`md5sum`),   KEY `idx_url` (`url`(75)),   KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),   KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_terms0` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_terms1` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_terms2` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_terms3` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_terms4` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_terms5` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_terms6` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_terms7` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_terms8` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_terms9` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_termsa` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_termsb` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_termsc` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_termsd` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_termse` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_links_termsf` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_taxonomy` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `parent_id` int(10) unsigned NOT NULL DEFAULT '0',   `title` varchar(255) NOT NULL,   `state` tinyint(1) unsigned NOT NULL DEFAULT '1',   `access` tinyint(1) unsigned NOT NULL DEFAULT '0',   `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `parent_id` (`parent_id`),   KEY `state` (`state`),   KEY `ordering` (`ordering`),   KEY `access` (`access`),   KEY `idx_parent_published` (`parent_id`,`state`,`access`) ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `canob_finder_taxonomy`  VALUES ('1', '0', 'ROOT', '0', '0', '0');
CREATE TABLE `canob_finder_taxonomy_map` (   `link_id` int(10) unsigned NOT NULL,   `node_id` int(10) unsigned NOT NULL,   PRIMARY KEY (`link_id`,`node_id`),   KEY `link_id` (`link_id`),   KEY `node_id` (`node_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_terms` (   `term_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `term` varchar(75) NOT NULL,   `stem` varchar(75) NOT NULL,   `common` tinyint(1) unsigned NOT NULL DEFAULT '0',   `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',   `weight` float unsigned NOT NULL DEFAULT '0',   `soundex` varchar(75) NOT NULL,   `links` int(10) NOT NULL DEFAULT '0',   PRIMARY KEY (`term_id`),   UNIQUE KEY `idx_term` (`term`),   KEY `idx_term_phrase` (`term`,`phrase`),   KEY `idx_stem_phrase` (`stem`,`phrase`),   KEY `idx_soundex_phrase` (`soundex`,`phrase`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_terms_common` (   `term` varchar(75) NOT NULL,   `language` varchar(3) NOT NULL,   KEY `idx_word_lang` (`term`,`language`),   KEY `idx_lang` (`language`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `canob_finder_terms_common`  VALUES ('a', 'en'), ('about', 'en'), ('after', 'en'), ('ago', 'en'), ('all', 'en'), ('am', 'en'), ('an', 'en'), ('and', 'en'), ('ani', 'en'), ('any', 'en');
INSERT INTO `canob_finder_terms_common`  VALUES ('are', 'en'), ('aren\'t', 'en'), ('as', 'en'), ('at', 'en'), ('be', 'en'), ('but', 'en'), ('by', 'en'), ('for', 'en'), ('from', 'en'), ('get', 'en');
INSERT INTO `canob_finder_terms_common`  VALUES ('go', 'en'), ('how', 'en'), ('if', 'en'), ('in', 'en'), ('into', 'en'), ('is', 'en'), ('isn\'t', 'en'), ('it', 'en'), ('its', 'en'), ('me', 'en');
INSERT INTO `canob_finder_terms_common`  VALUES ('more', 'en'), ('most', 'en'), ('must', 'en'), ('my', 'en'), ('new', 'en'), ('no', 'en'), ('none', 'en'), ('not', 'en'), ('noth', 'en'), ('nothing', 'en');
INSERT INTO `canob_finder_terms_common`  VALUES ('of', 'en'), ('off', 'en'), ('often', 'en'), ('old', 'en'), ('on', 'en'), ('onc', 'en'), ('once', 'en'), ('onli', 'en'), ('only', 'en'), ('or', 'en');
INSERT INTO `canob_finder_terms_common`  VALUES ('other', 'en'), ('our', 'en'), ('ours', 'en'), ('out', 'en'), ('over', 'en'), ('page', 'en'), ('she', 'en'), ('should', 'en'), ('small', 'en'), ('so', 'en');
INSERT INTO `canob_finder_terms_common`  VALUES ('some', 'en'), ('than', 'en'), ('thank', 'en'), ('that', 'en'), ('the', 'en'), ('their', 'en'), ('theirs', 'en'), ('them', 'en'), ('then', 'en'), ('there', 'en');
INSERT INTO `canob_finder_terms_common`  VALUES ('these', 'en'), ('they', 'en'), ('this', 'en'), ('those', 'en'), ('thus', 'en'), ('time', 'en'), ('times', 'en'), ('to', 'en'), ('too', 'en'), ('true', 'en');
INSERT INTO `canob_finder_terms_common`  VALUES ('under', 'en'), ('until', 'en'), ('up', 'en'), ('upon', 'en'), ('use', 'en'), ('user', 'en'), ('users', 'en'), ('veri', 'en'), ('version', 'en'), ('very', 'en');
INSERT INTO `canob_finder_terms_common`  VALUES ('via', 'en'), ('want', 'en'), ('was', 'en'), ('way', 'en'), ('were', 'en'), ('what', 'en'), ('when', 'en'), ('where', 'en'), ('whi', 'en'), ('which', 'en');
INSERT INTO `canob_finder_terms_common`  VALUES ('who', 'en'), ('whom', 'en'), ('whose', 'en'), ('why', 'en'), ('wide', 'en'), ('will', 'en'), ('with', 'en'), ('within', 'en'), ('without', 'en'), ('would', 'en');
INSERT INTO `canob_finder_terms_common`  VALUES ('yes', 'en'), ('yet', 'en'), ('you', 'en'), ('your', 'en'), ('yours', 'en');
CREATE TABLE `canob_finder_tokens` (   `term` varchar(75) NOT NULL,   `stem` varchar(75) NOT NULL,   `common` tinyint(1) unsigned NOT NULL DEFAULT '0',   `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',   `weight` float unsigned NOT NULL DEFAULT '1',   `context` tinyint(1) unsigned NOT NULL DEFAULT '2',   KEY `idx_word` (`term`),   KEY `idx_context` (`context`) ) ENGINE=MEMORY DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_tokens_aggregate` (   `term_id` int(10) unsigned NOT NULL,   `map_suffix` char(1) NOT NULL,   `term` varchar(75) NOT NULL,   `stem` varchar(75) NOT NULL,   `common` tinyint(1) unsigned NOT NULL DEFAULT '0',   `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',   `term_weight` float unsigned NOT NULL,   `context` tinyint(1) unsigned NOT NULL DEFAULT '2',   `context_weight` float unsigned NOT NULL,   `total_weight` float unsigned NOT NULL,   KEY `token` (`term`),   KEY `keyword_id` (`term_id`) ) ENGINE=MEMORY DEFAULT CHARSET=utf8;
CREATE TABLE `canob_finder_types` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `title` varchar(100) NOT NULL,   `mime` varchar(100) NOT NULL,   PRIMARY KEY (`id`),   UNIQUE KEY `title` (`title`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_languages` (   `lang_id` int(11) unsigned NOT NULL AUTO_INCREMENT,   `lang_code` char(7) NOT NULL,   `title` varchar(50) NOT NULL,   `title_native` varchar(50) NOT NULL,   `sef` varchar(50) NOT NULL,   `image` varchar(50) NOT NULL,   `description` varchar(512) NOT NULL,   `metakey` text NOT NULL,   `metadesc` text NOT NULL,   `sitename` varchar(1024) NOT NULL DEFAULT '',   `published` int(11) NOT NULL DEFAULT '0',   `access` int(10) unsigned NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`lang_id`),   UNIQUE KEY `idx_sef` (`sef`),   UNIQUE KEY `idx_image` (`image`),   UNIQUE KEY `idx_langcode` (`lang_code`),   KEY `idx_ordering` (`ordering`),   KEY `idx_access` (`access`) ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `canob_languages`  VALUES ('1', 'en-GB', 'English (UK)', 'English (UK)', 'en', 'en', '', '', '', '', '1', '0', '1');
CREATE TABLE `canob_menu` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `menutype` varchar(24) NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',   `title` varchar(255) NOT NULL COMMENT 'The display title of the menu item.',   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The SEF alias of the menu item.',   `note` varchar(255) NOT NULL DEFAULT '',   `path` varchar(1024) NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',   `link` varchar(1024) NOT NULL COMMENT 'The actually link the menu item refers to.',   `type` varchar(16) NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',   `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',   `parent_id` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',   `level` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',   `component_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',   `ordering` int(11) NOT NULL DEFAULT '0' COMMENT 'The relative ordering of the menu item in the tree.',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',   `checked_out_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',   `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',   `access` int(10) unsigned DEFAULT NULL,   `img` varchar(255) NOT NULL COMMENT 'The image of the menu item.',   `template_style_id` int(10) unsigned NOT NULL DEFAULT '0',   `params` text NOT NULL COMMENT 'JSON encoded data for the menu item.',   `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',   `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',   `home` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',   `language` char(7) NOT NULL DEFAULT '',   `client_id` tinyint(4) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`,`language`),   KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),   KEY `idx_menutype` (`menutype`),   KEY `idx_left_right` (`lft`,`rgt`),   KEY `idx_alias` (`alias`),   KEY `idx_path` (`path`(333)),   KEY `idx_language` (`language`) ) ENGINE=MyISAM AUTO_INCREMENT=218 DEFAULT CHARSET=utf8;
INSERT INTO `canob_menu`  VALUES ('1', '', 'Menu_Item_Root', 'root', '', '', '', '', '1', '0', '0', '0', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '0', '193', '0', '*', '0'), ('2', 'menu', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', '0', '1', '1', '4', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners', '0', '', '1', '10', '0', '*', '1'), ('3', 'menu', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', '0', '2', '2', '4', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners', '0', '', '2', '3', '0', '*', '1'), ('4', 'menu', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', '0', '2', '2', '6', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners-cat', '0', '', '4', '5', '0', '*', '1'), ('5', 'menu', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', '0', '2', '2', '4', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners-clients', '0', '', '6', '7', '0', '*', '1'), ('6', 'menu', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', '0', '2', '2', '4', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners-tracks', '0', '', '8', '9', '0', '*', '1'), ('7', 'menu', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', '0', '1', '1', '8', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:contact', '0', '', '61', '66', '0', '*', '1'), ('8', 'menu', 'com_contact', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', '0', '7', '2', '8', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:contact', '0', '', '62', '63', '0', '*', '1'), ('9', 'menu', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', '0', '7', '2', '6', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:contact-cat', '0', '', '64', '65', '0', '*', '1'), ('10', 'menu', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', '0', '1', '1', '15', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:messages', '0', '', '67', '72', '0', '*', '1');
INSERT INTO `canob_menu`  VALUES ('11', 'menu', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', '0', '10', '2', '15', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:messages-add', '0', '', '68', '69', '0', '*', '1'), ('12', 'menu', 'com_messages_read', 'Read Private Message', '', 'Messaging/Read Private Message', 'index.php?option=com_messages', 'component', '0', '10', '2', '15', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:messages-read', '0', '', '70', '71', '0', '*', '1'), ('13', 'menu', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', '0', '1', '1', '17', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:newsfeeds', '0', '', '73', '78', '0', '*', '1'), ('14', 'menu', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', '0', '13', '2', '17', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:newsfeeds', '0', '', '74', '75', '0', '*', '1'), ('15', 'menu', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', '0', '13', '2', '6', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:newsfeeds-cat', '0', '', '76', '77', '0', '*', '1'), ('16', 'menu', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', '0', '1', '1', '24', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:redirect', '0', '', '87', '88', '0', '*', '1'), ('17', 'menu', 'com_search', 'Search', '', 'Search', 'index.php?option=com_search', 'component', '0', '1', '1', '19', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:search', '0', '', '79', '80', '0', '*', '1'), ('18', 'menu', 'com_weblinks', 'Weblinks', '', 'Weblinks', 'index.php?option=com_weblinks', 'component', '0', '1', '1', '21', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:weblinks', '0', '', '81', '86', '0', '*', '1'), ('19', 'menu', 'com_weblinks_links', 'Links', '', 'Weblinks/Links', 'index.php?option=com_weblinks', 'component', '0', '18', '2', '21', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:weblinks', '0', '', '82', '83', '0', '*', '1'), ('20', 'menu', 'com_weblinks_categories', 'Categories', '', 'Weblinks/Categories', 'index.php?option=com_categories&extension=com_weblinks', 'component', '0', '18', '2', '6', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:weblinks-cat', '0', '', '84', '85', '0', '*', '1');
INSERT INTO `canob_menu`  VALUES ('21', 'menu', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', '0', '1', '1', '27', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:finder', '0', '', '57', '58', '0', '*', '1'), ('22', 'menu', 'com_joomlaupdate', 'Joomla! Update', '', 'Joomla! Update', 'index.php?option=com_joomlaupdate', 'component', '0', '1', '1', '28', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:joomlaupdate', '0', '', '55', '56', '0', '*', '1'), ('101', 'mainmenu', 'Accueil', 'accueil', '', 'accueil', 'index.php?option=com_content&view=article&id=7', 'component', '1', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '11', '22', '1', '*', '0'), ('102', 'mainmenu', 'Caractéristiques', 'features', '', 'creation-du-site/template-grangeweb/features', 'index.php?option=com_content&view=article&id=6', 'component', '1', '193', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '25', '26', '0', '*', '0'), ('103', 'mainmenu', 'Modules variables', 'modules-variables', '', 'creation-du-site/template-grangeweb/modules-variables', 'index.php?option=com_content&view=article&id=1', 'component', '1', '193', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '29', '30', '0', '*', '0'), ('104', 'mainmenu', 'Typographie', 'typography', '', 'creation-du-site/template-grangeweb/typography', 'index.php?option=com_content&view=article&id=4', 'component', '1', '193', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '27', '28', '0', '*', '0'), ('105', 'mainmenu', 'Icons', 'icons', '', 'icons', 'index.php?option=com_content&view=article&id=2', 'component', '-2', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '59', '60', '0', '*', '0'), ('106', 'mainmenu', 'ZOO', 'zoo', '', 'zoo', 'index.php?option=com_content&view=article&id=3', 'component', '-2', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '89', '90', '0', '*', '0'), ('107', 'mainmenu', 'Joomla || Subtitle Possible', 'joomla', '', 'joomla', 'index.php?option=com_content&view=category&layout=blog&id=7', 'component', '0', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"3\",\"num_columns\":\"1\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"order\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/yootheme\\/menu\\/icon_joomla.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '91', '112', '0', '*', '0'), ('108', 'topmenu', 'Features', '2011-05-02-12-32-40', '', '2011-05-02-12-32-40', 'index.php?option=com_content&view=article&id=6&Itemid=102', 'url', '-2', '1', '1', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '113', '114', '0', '*', '0');
INSERT INTO `canob_menu`  VALUES ('109', 'topmenu', 'Typography', '2011-05-02-12-33-12', '', '2011-05-02-12-33-12', 'index.php?option=com_content&view=article&id=4&Itemid=104', 'url', '-2', '1', '1', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '115', '116', '0', '*', '0'), ('110', 'topmenu', 'News', '2011-05-02-12-33-35', '', '2011-05-02-12-33-35', 'index.php?option=com_content&view=category&layout=blog&id=7&Itemid=107', 'url', '-2', '1', '1', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '117', '118', '0', '*', '0'), ('111', 'sidebarmenu', 'Sample Levels', 'sample-levels', '', 'sample-levels', 'index.php?option=com_content&view=article&id=5', 'component', '1', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '119', '130', '0', '*', '0'), ('112', 'sidebarmenu', 'Level 2', 'level-2', '', 'sample-levels/level-2', 'index.php?option=com_content&view=article&id=5', 'component', '1', '111', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '120', '121', '0', '*', '0'), ('113', 'sidebarmenu', 'Level 2', 'level-21', '', 'sample-levels/level-21', 'index.php?option=com_content&view=article&id=5', 'component', '1', '111', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '122', '127', '0', '*', '0'), ('114', 'sidebarmenu', 'Level 3', 'level-3', '', 'sample-levels/level-21/level-3', 'index.php?option=com_content&view=article&id=5', 'component', '1', '113', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '123', '126', '0', '*', '0'), ('115', 'sidebarmenu', 'Level 4', 'level-4', '', 'sample-levels/level-21/level-3/level-4', 'index.php?option=com_content&view=article&id=5', 'component', '1', '114', '4', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '124', '125', '0', '*', '0'), ('116', 'sidebarmenu', 'Level 2', 'level-22', '', 'sample-levels/level-22', 'index.php?option=com_content&view=article&id=5', 'component', '1', '111', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '128', '129', '0', '*', '0'), ('117', 'sidebarmenu', 'Accordion A', 'accordion-a', '', 'accordion-a', '', 'separator', '1', '1', '1', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu_image\":\"\",\"menu_text\":1}', '131', '138', '0', '*', '0'), ('118', 'sidebarmenu', 'Level 2', 'level-2', '', 'accordion-a/level-2', 'index.php?option=com_content&view=article&id=5', 'component', '1', '117', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '132', '133', '0', '*', '0');
INSERT INTO `canob_menu`  VALUES ('119', 'sidebarmenu', 'Level 2', 'level-21', '', 'accordion-a/level-21', 'index.php?option=com_content&view=article&id=5', 'component', '1', '117', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '134', '135', '0', '*', '0'), ('120', 'sidebarmenu', 'Level 2', 'level-22', '', 'accordion-a/level-22', 'index.php?option=com_content&view=article&id=5', 'component', '1', '117', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '136', '137', '0', '*', '0'), ('121', 'sidebarmenu', 'Accordion B', 'accordion-b', '', 'accordion-b', '', 'separator', '1', '1', '1', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu_image\":\"\",\"menu_text\":1}', '139', '144', '0', '*', '0'), ('122', 'sidebarmenu', 'Level 2', 'level-2', '', 'accordion-b/level-2', 'index.php?option=com_content&view=article&id=5', 'component', '1', '121', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '140', '141', '0', '*', '0'), ('123', 'sidebarmenu', 'Level 2', 'level-21', '', 'accordion-b/level-21', 'index.php?option=com_content&view=article&id=5', 'component', '1', '121', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '142', '143', '0', '*', '0'), ('124', 'mainmenu', 'Content||All com_content views', 'contentall-comcontent-views', '', 'joomla/contentall-comcontent-views', '', 'separator', '0', '107', '2', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu_image\":\"\",\"menu_text\":1}', '92', '97', '0', '*', '0'), ('125', 'mainmenu', 'Other Components||Remaining component views', 'loginall-comuser-views', '', 'joomla/loginall-comuser-views', '', 'separator', '0', '107', '2', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu_image\":\"\",\"menu_text\":1}', '102', '111', '0', '*', '0'), ('126', 'mainmenu', 'Category List', 'category-list', '', 'joomla/contentall-comcontent-views/category-list', 'index.php?option=com_content&view=category&id=7', 'component', '0', '124', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"show_pagination_limit\":\"\",\"filter_field\":\"\",\"show_headings\":\"\",\"list_show_date\":\"\",\"date_format\":\"\",\"list_show_hits\":\"\",\"list_show_author\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"display_num\":\"10\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"Blog\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '95', '96', '0', '*', '0'), ('127', 'mainmenu', 'Liste des contacts', 'list-all-categories', '', 'list-all-categories', 'index.php?option=com_content&view=categories&id=0', 'component', '-2', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_base_description\":\"\",\"categories_description\":\"\",\"maxLevelcat\":\"\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_num_articles_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_pagination_limit\":\"\",\"filter_field\":\"\",\"show_headings\":\"\",\"list_show_date\":\"\",\"date_format\":\"\",\"list_show_hits\":\"\",\"list_show_author\":\"\",\"display_num\":\"10\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"Blog\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '171', '172', '0', '*', '0'), ('128', 'mainmenu', 'Featured Articles', 'featured-articles', '', 'joomla/contentall-comcontent-views/featured-articles', 'index.php?option=com_content&view=featured', 'component', '0', '124', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"layout_type\":\"blog\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '93', '94', '0', '*', '0');
INSERT INTO `canob_menu`  VALUES ('129', 'mainmenu', 'Login', 'login', '', 'joomla/loginall-comuser-views/login', 'index.php?option=com_users&view=login', 'component', '0', '125', '3', '25', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"login_redirect_url\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"logout_redirect_url\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"Login\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '103', '104', '0', '*', '0'), ('130', 'mainmenu', 'Registration', 'registration', '', 'joomla/loginall-comuser-views/registration', 'index.php?option=com_users&view=registration', 'component', '0', '125', '3', '25', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"Registration\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '105', '106', '0', '*', '0'), ('131', 'mainmenu', 'Profile Default', '2011-05-06-15-22-51', '', 'accueil/2011-05-06-15-22-51', 'index.php?option=com_content&view=article&id=7&Itemid=101&profile=default', 'url', '-2', '101', '2', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '12', '13', '0', '*', '0'), ('132', 'mainmenu', 'Profile Header', '2011-05-06-15-24-05', '', 'accueil/2011-05-06-15-24-05', 'index.php?option=com_content&view=article&id=7&Itemid=101&profile=header', 'url', '-2', '101', '2', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '14', '15', '0', '*', '0'), ('133', 'mainmenu', 'Profile Blocks', '2011-05-06-15-24-54', '', 'accueil/2011-05-06-15-24-54', 'index.php?option=com_content&view=article&id=7&Itemid=101&profile=blocks', 'url', '-2', '101', '2', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '16', '17', '0', '*', '0'), ('134', 'mainmenu', 'Profile Pop', '2011-05-06-15-25-15', '', 'accueil/2011-05-06-15-25-15', 'index.php?option=com_content&view=article&id=7&Itemid=101&profile=pop', 'url', '-2', '101', '2', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '18', '19', '0', '*', '0'), ('135', 'mainmenu', 'Profile Page', '2011-05-06-15-25-45', '', 'accueil/2011-05-06-15-25-45', 'index.php?option=com_content&view=article&id=7&Itemid=101&profile=page', 'url', '-2', '101', '2', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '20', '21', '0', '*', '0'), ('137', 'mainmenu', 'Widgetkit', 'widgetkit', '', 'creation-du-site/widgetkit', 'index.php?option=com_content&view=article&id=13', 'component', '1', '192', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '34', '53', '0', '*', '0'), ('138', 'mainmenu', 'Slideshow', 'slideshow', '', 'creation-du-site/widgetkit/slideshow', 'index.php?option=com_content&view=article&id=14', 'component', '1', '137', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '35', '36', '0', '*', '0'), ('139', 'mainmenu', 'Lightbox', 'lightbox', '', 'creation-du-site/widgetkit/lightbox', 'index.php?option=com_content&view=article&id=15', 'component', '1', '137', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '45', '46', '0', '*', '0');
INSERT INTO `canob_menu`  VALUES ('140', 'mainmenu', 'Spotlight', 'spotlight', '', 'creation-du-site/widgetkit/spotlight', 'index.php?option=com_content&view=article&id=16', 'component', '1', '137', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '47', '48', '0', '*', '0'), ('141', 'mainmenu', 'Twitter', 'twitter', '', 'creation-du-site/widgetkit/twitter', 'index.php?option=com_content&view=article&id=17', 'component', '1', '137', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '49', '50', '0', '*', '0'), ('145', 'mainmenu', 'Media Player', 'media-player', '', 'creation-du-site/widgetkit/media-player', 'index.php?option=com_content&view=article&id=18', 'component', '1', '137', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '51', '52', '0', '*', '0'), ('146', 'mainmenu', 'Map', 'map', '', 'creation-du-site/widgetkit/map', 'index.php?option=com_content&view=article&id=20', 'component', '1', '137', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '41', '42', '0', '*', '0'), ('147', 'mainmenu', 'Slideset', 'slideset', '', 'creation-du-site/widgetkit/slideset', 'index.php?option=com_content&view=article&id=22', 'component', '1', '137', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '37', '38', '0', '*', '0'), ('148', 'mainmenu', 'Accordion', 'accordion', '', 'creation-du-site/widgetkit/accordion', 'index.php?option=com_content&view=article&id=21', 'component', '1', '137', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '43', '44', '0', '*', '0'), ('149', 'mainmenu', 'Gallery', 'gallery', '', 'creation-du-site/widgetkit/gallery', 'index.php?option=com_content&view=article&id=19', 'component', '1', '137', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '39', '40', '0', '*', '0'), ('155', 'mainmenu', 'Contact || All com_contact views', 'contact--all-comcontact-views', '', 'joomla/contact--all-comcontact-views', '', 'separator', '0', '107', '2', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu_image\":\"\",\"menu_text\":1}', '98', '101', '0', '*', '0'), ('156', 'mainmenu', 'Liste des contacts', 'liste-des-contacts', '', 'liste-des-contacts', 'index.php?option=com_contact&view=category&id=8', 'component', '1', '1', '1', '8', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"initial_sort\":\"\",\"presentation_style\":\"\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '173', '174', '0', '*', '0'), ('157', 'mainmenu', 'Contact Item', 'contact-item', '', 'joomla/contact--all-comcontact-views/contact-item', 'index.php?option=com_contact&view=contact&id=3', 'component', '0', '155', '3', '8', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"presentation_style\":\"\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '99', '100', '0', '*', '0');
INSERT INTO `canob_menu`  VALUES ('158', 'mainmenu', 'Liens', 'liens', '', 'liens', 'index.php?option=com_weblinks&view=categories&id=0', 'component', '1', '1', '1', '21', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_base_description\":\"1\",\"categories_description\":\"We are regularly out on the Web. When we find a great site we list it.\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_num_links_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_links\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_link_description\":\"\",\"show_link_hits\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"Liens Web\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '175', '176', '0', '*', '0'), ('159', 'mainmenu', 'Remind', 'remind', '', 'joomla/loginall-comuser-views/remind', 'index.php?option=com_users&view=remind', 'component', '0', '125', '3', '25', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"Forgot your Username?\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '107', '108', '0', '*', '0'), ('160', 'mainmenu', 'Reset', 'reset', '', 'joomla/loginall-comuser-views/reset', 'index.php?option=com_users&view=reset', 'component', '0', '125', '3', '25', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"Forgot your Password?\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '109', '110', '0', '*', '0'), ('167', 'topmenu', 'administration du site', '2012-02-25-13-17-44', '', '2012-02-25-13-17-44', '/administrator', 'url', '1', '1', '1', '0', '0', '0', '0000-00-00 00:00:00', '1', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '145', '146', '0', '*', '0'), ('179', 'main', 'COM_PHOCADOWNLOAD', 'com-phocadownload', '', 'com-phocadownload', 'index.php?option=com_phocadownload', 'component', '0', '1', '1', '10018', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu.png', '0', '', '147', '168', '0', '', '1'), ('180', 'main', 'COM_PHOCADOWNLOAD_CONTROLPANEL', 'com-phocadownload-controlpanel', '', 'com-phocadownload/com-phocadownload-controlpanel', 'index.php?option=com_phocadownload', 'component', '0', '179', '2', '10018', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-control-panel.png', '0', '', '148', '149', '0', '', '1'), ('181', 'main', 'COM_PHOCADOWNLOAD_FILES', 'com-phocadownload-files', '', 'com-phocadownload/com-phocadownload-files', 'index.php?option=com_phocadownload&view=phocadownloadfiles', 'component', '0', '179', '2', '10018', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-files.png', '0', '', '150', '151', '0', '', '1'), ('182', 'main', 'COM_PHOCADOWNLOAD_CATEGORIES', 'com-phocadownload-categories', '', 'com-phocadownload/com-phocadownload-categories', 'index.php?option=com_phocadownload&view=phocadownloadcats', 'component', '0', '179', '2', '10018', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-category.png', '0', '', '152', '153', '0', '', '1'), ('183', 'main', 'COM_PHOCADOWNLOAD_LICENSES', 'com-phocadownload-licenses', '', 'com-phocadownload/com-phocadownload-licenses', 'index.php?option=com_phocadownload&view=phocadownloadlics', 'component', '0', '179', '2', '10018', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-lic.png', '0', '', '154', '155', '0', '', '1'), ('184', 'main', 'COM_PHOCADOWNLOAD_STATISTICS', 'com-phocadownload-statistics', '', 'com-phocadownload/com-phocadownload-statistics', 'index.php?option=com_phocadownload&view=phocadownloadstat', 'component', '0', '179', '2', '10018', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-stat.png', '0', '', '156', '157', '0', '', '1');
INSERT INTO `canob_menu`  VALUES ('185', 'main', 'COM_PHOCADOWNLOAD_USERS', 'com-phocadownload-users', '', 'com-phocadownload/com-phocadownload-users', 'index.php?option=com_phocadownload&view=phocadownloadusers', 'component', '0', '179', '2', '10018', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-users.png', '0', '', '158', '159', '0', '', '1'), ('186', 'main', 'COM_PHOCADOWNLOAD_FILE_RATING', 'com-phocadownload-file-rating', '', 'com-phocadownload/com-phocadownload-file-rating', 'index.php?option=com_phocadownload&view=phocadownloadrafile', 'component', '0', '179', '2', '10018', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-vote-file.png', '0', '', '160', '161', '0', '', '1'), ('187', 'main', 'COM_PHOCADOWNLOAD_TAGS', 'com-phocadownload-tags', '', 'com-phocadownload/com-phocadownload-tags', 'index.php?option=com_phocadownload&view=phocadownloadtags', 'component', '0', '179', '2', '10018', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-tags.png', '0', '', '162', '163', '0', '', '1'), ('188', 'main', 'COM_PHOCADOWNLOAD_LAYOUT', 'com-phocadownload-layout', '', 'com-phocadownload/com-phocadownload-layout', 'index.php?option=com_phocadownload&view=phocadownloadlayouts', 'component', '0', '179', '2', '10018', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-layout.png', '0', '', '164', '165', '0', '', '1'), ('189', 'main', 'COM_PHOCADOWNLOAD_INFO', 'com-phocadownload-info', '', 'com-phocadownload/com-phocadownload-info', 'index.php?option=com_phocadownload&view=phocadownloadinfo', 'component', '0', '179', '2', '10018', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-info.png', '0', '', '166', '167', '0', '', '1'), ('191', 'mainmenu', 'Téléchargements', 'telechargements', '', 'telechargements', 'index.php?option=com_phocadownload&view=categories', 'component', '1', '1', '1', '10018', '0', '0', '0000-00-00 00:00:00', '0', '2', '', '0', '{\"show_pagination\":\"1\",\"show_pagination_limit\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '169', '170', '0', '*', '0'), ('192', 'mainmenu', 'Création du site', 'creation-du-site', '', 'creation-du-site', 'index.php?option=com_content&view=category&layout=blog&id=12', 'component', '1', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"order\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '23', '54', '0', '*', '0'), ('193', 'mainmenu', 'Template Grangeweb', 'template-grangeweb', '', 'creation-du-site/template-grangeweb', 'index.php?option=com_content&view=category&layout=blog&id=11', 'component', '1', '192', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"order\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '24', '31', '0', '*', '0'), ('194', 'mainmenu', 'Modules indispensables', 'modules-indispensables', '', 'creation-du-site/modules-indispensables', 'index.php?option=com_content&view=category&layout=blog&id=13', 'component', '1', '192', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"order\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '32', '33', '0', '*', '0'), ('202', 'topmenu', 'Votre profil utilisateur', 'votre-profil-utilisateur', '', 'votre-profil-utilisateur', 'index.php?option=com_users&view=profile', 'component', '1', '1', '1', '25', '0', '0', '0000-00-00 00:00:00', '0', '2', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '177', '178', '0', '*', '0');
INSERT INTO `canob_menu`  VALUES ('211', 'main', 'COM_AKEEBA', 'com-akeeba', '', 'com-akeeba', 'index.php?option=com_akeeba', 'component', '0', '1', '1', '10030', '0', '0', '0000-00-00 00:00:00', '0', '1', '../media/com_akeeba/icons/akeeba-16.png', '0', '', '179', '180', '0', '', '1'), ('212', 'main', 'JCE', 'jce', '', 'jce', 'index.php?option=com_jce', 'component', '0', '1', '1', '10017', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_jce/media/img/menu/logo.png', '0', '', '181', '190', '0', '', '1'), ('213', 'main', 'WF_MENU_CPANEL', 'wf-menu-cpanel', '', 'jce/wf-menu-cpanel', 'index.php?option=com_jce', 'component', '0', '212', '2', '10017', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_jce/media/img/menu/jce-cpanel.png', '0', '', '182', '183', '0', '', '1'), ('214', 'main', 'WF_MENU_CONFIG', 'wf-menu-config', '', 'jce/wf-menu-config', 'index.php?option=com_jce&view=config', 'component', '0', '212', '2', '10017', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_jce/media/img/menu/jce-config.png', '0', '', '184', '185', '0', '', '1'), ('215', 'main', 'WF_MENU_PROFILES', 'wf-menu-profiles', '', 'jce/wf-menu-profiles', 'index.php?option=com_jce&view=profiles', 'component', '0', '212', '2', '10017', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_jce/media/img/menu/jce-profiles.png', '0', '', '186', '187', '0', '', '1'), ('216', 'main', 'WF_MENU_INSTALL', 'wf-menu-install', '', 'jce/wf-menu-install', 'index.php?option=com_jce&view=installer', 'component', '0', '212', '2', '10017', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_jce/media/img/menu/jce-install.png', '0', '', '188', '189', '0', '', '1'), ('217', 'main', 'COM_WIDGETKIT', 'com-widgetkit', '', 'com-widgetkit', 'index.php?option=com_widgetkit', 'component', '0', '1', '1', '10005', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_widgetkit/images/widgetkit_16.png', '0', '', '191', '192', '0', '', '1');
CREATE TABLE `canob_menu_types` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `menutype` varchar(24) NOT NULL,   `title` varchar(48) NOT NULL,   `description` varchar(255) NOT NULL DEFAULT '',   PRIMARY KEY (`id`),   UNIQUE KEY `idx_menutype` (`menutype`) ) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
INSERT INTO `canob_menu_types`  VALUES ('1', 'mainmenu', 'Main Menu', 'The main menu for the site'), ('2', 'topmenu', 'Top Menu', ''), ('3', 'sidebarmenu', 'Sidebar Menu', '');
CREATE TABLE `canob_messages` (   `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `user_id_from` int(10) unsigned NOT NULL DEFAULT '0',   `user_id_to` int(10) unsigned NOT NULL DEFAULT '0',   `folder_id` tinyint(3) unsigned NOT NULL DEFAULT '0',   `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `state` tinyint(1) NOT NULL DEFAULT '0',   `priority` tinyint(1) unsigned NOT NULL DEFAULT '0',   `subject` varchar(255) NOT NULL DEFAULT '',   `message` text NOT NULL,   PRIMARY KEY (`message_id`),   KEY `useridto_state` (`user_id_to`,`state`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_messages_cfg` (   `user_id` int(10) unsigned NOT NULL DEFAULT '0',   `cfg_name` varchar(100) NOT NULL DEFAULT '',   `cfg_value` varchar(255) NOT NULL DEFAULT '',   UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_modules` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `title` varchar(100) NOT NULL DEFAULT '',   `note` varchar(255) NOT NULL DEFAULT '',   `content` text NOT NULL,   `ordering` int(11) NOT NULL DEFAULT '0',   `position` varchar(50) NOT NULL DEFAULT '',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `published` tinyint(1) NOT NULL DEFAULT '0',   `module` varchar(50) DEFAULT NULL,   `access` int(10) unsigned DEFAULT NULL,   `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',   `params` text NOT NULL,   `client_id` tinyint(4) NOT NULL DEFAULT '0',   `language` char(7) NOT NULL,   PRIMARY KEY (`id`),   KEY `published` (`published`,`access`),   KEY `newsfeeds` (`module`,`published`),   KEY `idx_language` (`language`) ) ENGINE=MyISAM AUTO_INCREMENT=90 DEFAULT CHARSET=utf8;
INSERT INTO `canob_modules`  VALUES ('1', 'Menu Principal', '', '', '1', 'menu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '0', '{\"menutype\":\"mainmenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_menu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*'), ('2', 'Login', '', '', '1', 'login', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_login', '1', '1', '', '1', '*'), ('3', 'Popular Articles', '', '', '3', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_popular', '3', '1', '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', '1', '*'), ('4', 'Recently Added Articles', '', '', '4', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_latest', '3', '1', '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', '1', '*'), ('6', 'Unread Messages', '', '', '1', 'header', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_unread', '3', '1', '', '1', '*'), ('7', 'Online Users', '', '', '2', 'header', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_online', '3', '1', '', '1', '*'), ('8', 'Toolbar', '', '', '1', 'toolbar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_toolbar', '3', '1', '', '1', '*'), ('9', 'Quick Icons', '', '', '1', 'icon', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_quickicon', '3', '1', '', '1', '*'), ('10', 'Logged-in Users', '', '', '2', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_logged', '3', '1', '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', '1', '*'), ('12', 'Admin Menu', '', '', '1', 'menu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '3', '1', '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', '1', '*');
INSERT INTO `canob_modules`  VALUES ('13', 'Admin Submenu', '', '', '1', 'submenu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_submenu', '3', '1', '', '1', '*'), ('14', 'User Status', '', '', '2', 'status', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_status', '3', '1', '', '1', '*'), ('15', 'Title', '', '', '1', 'title', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_title', '3', '1', '', '1', '*'), ('17', 'Breadcrumbs', '', '', '1', 'breadcrumbs', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_breadcrumbs', '1', '1', '{\"showHere\":\"1\",\"showHome\":\"1\",\"homeText\":\"Home\",\"showLast\":\"1\",\"separator\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*'), ('19', 'Bottom A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Module Class Suffix <code>icon-download</code>', '1', 'bottom-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"icon-download\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('20', 'Bottom A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Module Class Suffix <code>icon-twitter</code>', '2', 'bottom-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"icon-twitter\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('21', 'Bottom A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Module Class Suffix <code>icon-mail</code>', '3', 'bottom-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"icon-mail\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('22', 'Bottom A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Module Class Suffix <code>icon-bubble</code>', '4', 'bottom-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"icon-bubble\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('23', 'Home Teaser Fast', '', '<img class=\"align-left\" src=\"images/yootheme/features_icon_lightweight.png\" width=\"42\" height=\"42\" />\r\n<div class=\"bfc-o\">\r\n	<h3 class=\"remove-margin\">Fast and lightweight</h3>\r\n	<p class=\"remove-margin-b\">Well designed and coded to provide optimal loading times.</p>\r\n</div>', '5', 'bottom-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_custom', '1', '0', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('24', 'Home Teaser Mobile', '', '<p><img alt=\"Iphone 4\" class=\"align-left\" src=\"images/info/Iphone_4.png\" height=\"57\" width=\"40\" /></p>\r\n<div class=\"bfc-o\">\r\n<div class=\"bfc-o\">\r\n<h3 class=\"remove-margin\">Prise en charge des téléphones Mobiles</h3>\r\n<p class=\"remove-margin-b\">Ce site permet un affichage personnalisé pour téléphones mobiles (Retina).</p>\r\n</div>\r\n</div>', '6', 'bottom-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '0', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `canob_modules`  VALUES ('25', 'Home Teaser HTML5', '', '<p><img alt=\"html5\" class=\"align-left\" src=\"images/info/html5.png\" height=\"50\" width=\"50\" /></p>\r\n<div class=\"bfc-o\">\r\n<div class=\"bfc-o\">\r\n<h3 class=\"remove-margin\">Ce site utilise les dernières techniques web</h3>\r\n<p class=\"remove-margin-b\">Il est complètement construit avec HTML5, CSS3, PHP 5.2+ et jQuery.</p>\r\n</div>\r\n</div>', '7', 'bottom-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '0', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('26', 'Home Teaser Demo', '', '<img class=\"align-left\" src=\"images/yootheme/features_icon_demo_package.png\" width=\"42\" height=\"46\" />\r\n<div class=\"bfc-o\">\r\n	<h3 class=\"remove-margin\">Demo Package available</h3>\r\n	<p class=\"remove-margin-b\">Sample data for Joomla and WordPress is available.</p>\r\n</div>', '8', 'bottom-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_custom', '1', '0', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('27', 'Bottom B', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Module Class Suffix <code>badge-hot</code>', '1', 'bottom-b', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"badge-hot\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('28', 'Bottom B', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Module Class Suffix <code>badge-new</code>', '2', 'bottom-b', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"badge-new\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('29', 'Bottom B', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Module Class Suffix <code>badge-free</code>', '3', 'bottom-b', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"badge-free\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('30', 'Bottom B', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Module Class Suffix <code>badge-top</code>', '4', 'bottom-b', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"badge-top\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('31', 'Footer Menu', '', '', '2', 'footer', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '1', '{\"menutype\":\"topmenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*'), ('32', 'Footer', '', '<p>Copyright © 2012 <a href=\"mailto:olivier.guignard@fr.ch\">IAGInfo</a></p>', '3', 'footer', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('33', 'Headerbar', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>', '1', 'headerbar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_custom', '1', '0', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('34', 'Inner Bottom', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Module Class Suffix <code>icon-login</code>', '1', 'innerbottom', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"icon-login\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `canob_modules`  VALUES ('35', 'Inner Bottom', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Module Class Suffix <code>icon-cart</code>', '2', 'innerbottom', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"icon-cart\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('36', 'Inner Top', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', '1', 'innertop', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('37', 'Inner Top', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', '2', 'innertop', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('38', 'Logo', '', '<p><img src=\"images/grangeweb/logo.png\" alt=\"logo\" height=\"100\" width=\"120\" /></p>\r\n<p><span style=\"font-family: arial,helvetica,sans-serif; color: #000000; font-size: 10pt;\">Institut agricole de l\'Etat de Fribourg - <strong>Grangeneuve</strong></span></p>', '1', 'logo', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('39', 'Login || Identification', '', '', '1', 'menu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_login', '1', '1', '{\"pretext\":\"\",\"posttext\":\"\",\"login\":\"\",\"logout\":\"\",\"greeting\":\"1\",\"name\":\"0\",\"usesecure\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '0', '*'), ('40', 'Rechercher', '', '', '1', 'search', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_search', '1', '1', '{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"button_pos\":\"right\",\"imagebutton\":\"\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*'), ('41', 'Widgetkit', '', '', '3', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_menu', '1', '0', '{\"menutype\":\"mainmenu\",\"startLevel\":\"3\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*'), ('42', 'Sidebar Menu', '', '', '1', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '1', '{\"menutype\":\"sidebarmenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*'), ('43', 'Sidebar A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', '2', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('44', 'Sidebar A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', '2', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `canob_modules`  VALUES ('45', 'Liste en ligne', '', '<p>Utilisez la CSS class <code>line</code> pour créer ce style de liste.</p>\r\n<ul class=\"line\">\r\n<li>ligne 1</li>\r\n<li>ligne 2</li>\r\n<li>ligne 3</li>\r\n<li>ligne 4</li>\r\n<li>ligne 5</li>\r\n</ul>', '5', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('46', 'Liste Zebra', '', '<p>Utilisez CSS class <code>zebra</code> pour créer ce style de lignes.</p>\r\n<ul class=\"zebra\">\r\n<li class=\"odd\">Ligne 1</li>\r\n<li>Ligne 2</li>\r\n<li class=\"odd\">Ligne 3</li>\r\n<li>Ligne 4</li>\r\n<li class=\"odd\">Ligne 5</li>\r\n</ul>', '6', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('47', 'List Check', '', '<p>Utilisez la CSS class <code>check</code> pour créer ce style de ligne.</p>\r\n<ul class=\"check\">\r\n<li>Ligne 1</li>\r\n<li>Ligne 2</li>\r\n<li>Ligne 3</li>\r\n<li>Ligne 4</li>\r\n<li>Ligne 5</li>\r\n</ul>', '7', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('48', 'Latest News', '', '', '8', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_articles_latest', '1', '1', '{\"catid\":[\"7\"],\"count\":\"5\",\"show_featured\":\"\",\"ordering\":\"p_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('49', 'Login', '', '', '9', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_login', '1', '1', '{\"pretext\":\"\",\"posttext\":\"\",\"login\":\"\",\"logout\":\"\",\"greeting\":\"1\",\"name\":\"0\",\"usesecure\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '0', '*'), ('50', 'Download ZOO', '', '<a class=\"display-block text-center\" href=\"http://www.yootheme.com/zoo\" target=\"_blank\"><img class=\"size-auto\" src=\"images/yootheme/zoo_icon.png\" alt=\"A flexible and powerful content application builder to manage your content\" title=\"A flexible and powerful content application builder to manage your content\" width=\"140\" height=\"130\" /></a>\r\n\r\n<p>A flexible and powerful content application builder to manage your content.</p>\r\n\r\n<p><a class=\"button-more\" href=\"http://www.yootheme.com/zoo\" target=\"_blank\">Download ZOO</a></p>', '10', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"badge-free\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('52', 'Icon Freebies', '', '<ul class=\"line text-center\">\r\n	<li>\r\n		<a href=\"http://www.yootheme.com/icons\" target=\"_blank\">\r\n			<figure>\r\n				<img class=\"size-auto\" height=\"120\" width=\"180\" src=\"images/yootheme/icons_socialbookmarks.png\" alt=\"Social Bookmarks Icons\" />\r\n				<figcaption>Social Bookmarks Icons</figcaption>\r\n			</figure>\r\n		</a>\r\n	</li>\r\n	<li>\r\n		<a href=\"http://www.yootheme.com/icons\" target=\"_blank\">\r\n			<figure>\r\n				<img class=\"size-auto\" height=\"120\" width=\"180\" src=\"images/yootheme/icons_halloween.png\" alt=\"Halloween Icons\" />\r\n				<figcaption>Halloween Icons</figcaption>\r\n			</figure>\r\n		</a>\r\n	</li>\r\n	<li>\r\n		<a href=\"http://www.yootheme.com/icons\" target=\"_blank\">\r\n			<figure>\r\n				<img class=\"size-auto\" height=\"120\" width=\"180\" src=\"images/yootheme/icons_html5geekmatt.png\" alt=\"HTML5 Geek Icon\" />\r\n				<figcaption>HTML5 Geek Icon</figcaption>\r\n			</figure>\r\n		</a>\r\n	</li>\r\n</ul>', '12', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"badge-free\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('53', 'Warp Framework', '', '<a class=\"display-block text-center\" href=\"http://www.yootheme.com/warp\" target=\"_blank\"><img class=\"size-auto\" src=\"images/yootheme/features_warp_icon.png\" alt=\"Warp is a fast and slick theme framework which provides a rich tool set to develop cross-platform themes\" title=\"Warp is a fast and slick theme framework which provides a rich tool set to develop cross-platform themes\" width=\"140\" height=\"130\" /></a>\r\n\r\n<p>A fast and slick theme framework built on the latest web techniques like HTML5, CSS3 and PHP 5.2+</p>\r\n\r\n<p><a class=\"button-more\" href=\"http://www.yootheme.com/warp\" target=\"_blank\">Visit Website</a></p>', '13', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('54', 'Warp Framework', '', '<p>Toutes les fonctionalités du \"Warp framework\" sont disponibles dans ce thème :</p>\r\n<ul class=\"check\">\r\n<li>Rapide et léger</li>\r\n<li>Thème pour Mobiles</li>\r\n<li>Avis de mise à jour</li>\r\n<li>Balises HTML5</li>\r\n<li>Support RTL</li>\r\n<li>Cadre CSS</li>\r\n<li>Administration conviviale</li>\r\n</ul>', '14', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('55', 'Librairies JavaScript', '', '<p>Tous les effets, côté client, utilise du JavaScript de type <a href=\"http://www.jquery.com\" target=\"_blank\">jQuery</a> qui permet des fonctionalités performantes et de petite taille!</p>', '15', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `canob_modules`  VALUES ('56', 'Warp6 Blog Posts', '', '<ul class=\"line\">\r\n	<li><a href=\"http://www.yootheme.com/blog/item/root/warp6-engage\" target=\"_blank\">Warp6 - Engage</a></li>\r\n	<li><a href=\"http://www.yootheme.com/blog/item/root/inside-the-warp6-framework\" target=\"_blank\">Inside the Framework</a></li>\r\n	<li><a href=\"http://www.yootheme.com/blog/item/root/warp6-styles\" target=\"_blank\">Warp6 Styles</a></li>\r\n	<li><a href=\"http://www.yootheme.com/blog/item/root/warp6-and-html5\" target=\"_blank\">Warp6 and HTML5</a></li>\r\n	<li><a href=\"http://www.yootheme.com/blog/item/root/warp6-css-framework\" target=\"_blank\">Warp6 CSS Framework</a></li>\r\n	<li><a href=\"http://www.yootheme.com/blog/item/root/warp6-administration\" target=\"_blank\">Warp6 Administration</a></li>\r\n	<li><a href=\"http://www.yootheme.com/blog/item/root/warp6-mobile-theme\" target=\"_blank\">Warp6 Mobile Theme</a></li>\r\n</ul>', '16', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('57', 'Sidebar B', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', '1', 'sidebar-b', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('58', 'Sidebar B', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', '2', 'sidebar-b', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('59', 'Sidebar B', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', '3', 'sidebar-b', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('60', 'Joomla & WordPress', '', '<img class=\"size-auto\" width=\"205\" height=\"90\" src=\"images/yootheme/features_icon_cross_platform.png\" />\r\n<p>This theme is available for Joomla and WordPress including the same features on each system.</p>', '4', 'sidebar-b', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('61', 'Top Menu', '', '', '0', 'toolbar-l', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '1', '{\"menutype\":\"topmenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*'), ('62', 'Top A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', '1', 'top-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('63', 'Top A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', '2', 'top-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('64', 'Top A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', '3', 'top-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('65', 'Top A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', '4', 'top-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `canob_modules`  VALUES ('66', 'Icons Shipping', '', '<a href=\"http://www.yootheme.com/icons\" target=\"_blank\" class=\"display-block text-center\">\r\n	<figure class=\"remove-margin\">\r\n		<img class=\"size-auto\" height=\"120\" width=\"180\" src=\"images/yootheme/icons_shipping.png\" alt=\"Shipping Icons\" />\r\n		<figcaption>Shipping Icons</figcaption>\r\n	</figure>\r\n</a>', '5', 'top-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '0', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('67', 'Icons E-Commerce', '', '<a href=\"http://www.yootheme.com/icons\" target=\"_blank\" class=\"display-block text-center\">\r\n	<figure class=\"remove-margin\">\r\n		<img class=\"size-auto\" height=\"120\" width=\"180\" src=\"images/yootheme/icons_ecommerce.png\" alt=\"E-Commerce Icons\" />\r\n		<figcaption>E-Commerce Icons</figcaption>\r\n	</figure>\r\n</a>', '6', 'top-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '0', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('68', 'Icons Action', '', '<a href=\"http://www.yootheme.com/icons\" target=\"_blank\" class=\"display-block text-center\">\r\n	<figure class=\"remove-margin\">\r\n		<img class=\"size-auto\" height=\"120\" width=\"180\" src=\"images/yootheme/icons_actions.png\" alt=\"Action Icons\" />\r\n		<figcaption>Action Icons</figcaption>\r\n	</figure>\r\n</a>', '7', 'top-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '0', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('69', 'Icons Box', '', '<a href=\"http://www.yootheme.com/icons\" target=\"_blank\" class=\"display-block text-center\">\r\n	<figure class=\"remove-margin\">\r\n		<img class=\"size-auto\" height=\"120\" width=\"180\" src=\"images/yootheme/icons_box.png\" alt=\"Box Icons\" />\r\n		<figcaption>Box Icons</figcaption>\r\n	</figure>\r\n</a>', '8', 'top-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '0', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('70', 'Warp Teaser', '', '<div class=\"text-center\"><img class=\"size-auto\" src=\"images/yootheme/home_warp_teaser.jpg\" height=\"300\" border=\"0\" width=\"915\" />\r\n<h1 style=\"margin: 15px 0 10px 0; letter-spacing: 2px;\">Introducing Warp6</h1>\r\n<p style=\"margin: 0; font-size: 26px; color: #999999;\">The fast and slick theme framework</p>\r\n</div>', '9', 'top-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('71', 'Top B', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', '1', 'top-b', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('72', 'Top B', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', '2', 'top-b', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('73', 'Top B', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', '3', 'top-b', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('74', 'Top B', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', '4', 'top-b', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('75', 'Widgetkit', '', '', '0', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_widgetkit', '1', '1', '', '0', '*');
INSERT INTO `canob_modules`  VALUES ('76', 'Twitter List', '', '', '1', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_widgetkit_twitter', '1', '0', '{\"style\":\"list\",\"from_user\":\"yootheme\",\"to_user\":\"\",\"ref_user\":\"\",\"hashtag\":\"\",\"word\":\"\",\"nots\":\"\",\"limit\":\"4\",\"image_size\":\"48\",\"show_image\":\"1\",\"show_author\":\"1\",\"show_date\":\"1\",\"moduleclass_sfx\":\"\"}', '0', '*'), ('77', 'Get Widgetkit', '', '<a class=\"display-block text-center\" href=\"http://www.yootheme.com/blog/item/root/introducing-widgetkit\" target=\"_blank\"><img class=\"size-auto\" src=\"images/yootheme/widgetkit_icon.png\" alt=\"The next generation tool set for Joomla and WordPress\" title=\"The next generation tool set for Joomla and WordPress\" width=\"140\" height=\"130\" /></a>\r\n\r\n<p>The next generation tool set for Joomla and WordPress</p>\r\n\r\n<p><a class=\"button-more\" href=\"http://www.yootheme.com/widgetkit\" target=\"_blank\">Download Widgetkit</a></p>', '1', 'sidebar-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"badge-free\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('78', 'Twitter Bubbles', '', '', '1', 'bottom-a', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_widgetkit_twitter', '1', '0', '{\"style\":\"bubbles\",\"from_user\":\"yootheme\",\"to_user\":\"\",\"ref_user\":\"\",\"hashtag\":\"\",\"word\":\"\",\"nots\":\"\",\"limit\":\"4\",\"image_size\":\"48\",\"show_image\":\"1\",\"show_author\":\"1\",\"show_date\":\"1\",\"moduleclass_sfx\":\"\"}', '0', '*'), ('79', 'Twitter Single', '', '', '1', 'innerbottom', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_widgetkit_twitter', '1', '0', '{\"style\":\"single\",\"from_user\":\"yootheme\",\"to_user\":\"\",\"ref_user\":\"\",\"hashtag\":\"\",\"word\":\"\",\"nots\":\"\",\"limit\":\"4\",\"image_size\":\"48\",\"show_image\":\"1\",\"show_author\":\"1\",\"show_date\":\"1\",\"moduleclass_sfx\":\"\"}', '0', '*'), ('80', 'Multilanguage status', '', '', '1', 'status', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_multilangstatus', '3', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'), ('81', 'Joomla Version', '', '', '1', 'footer', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_version', '3', '1', '{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'), ('82', 'Barre couleur', '', '<p>&nbsp;<img alt=\"bonhomme1\" src=\"images/grangeweb/bonhomme1.png\" height=\"106\" width=\"200\" /></p>\r\n<p><img alt=\"barrerouge\" src=\"images/grangeweb/barrerouge.jpg\" height=\"10\" width=\"300\" /></p>', '1', 'headerbar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('83', 'Akeeba Backup Notification Module', '', '', '0', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_akadmin', '1', '1', '', '1', '*'), ('84', 'Search (2)', '', '', '1', 'search', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_search', '1', '1', '{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"button_pos\":\"right\",\"imagebutton\":\"\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*'), ('85', 'Search (2)', '', '', '1', 'search', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_search', '1', '1', '{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"button_pos\":\"right\",\"imagebutton\":\"\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*');
INSERT INTO `canob_modules`  VALUES ('86', 'Barre couleur (2)', '', '<p>&nbsp;<img alt=\"barrerouge\" src=\"images/grangeweb/barrerouge.jpg\" height=\"10\" width=\"250\" /></p>', '1', 'headerbar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('87', 'Barre couleur (3)', '', '<p>&nbsp;<img alt=\"barrerouge\" src=\"images/grangeweb/barrerouge.jpg\" height=\"10\" width=\"250\" /></p>', '1', 'headerbar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('88', 'rougetop', '', '<p><img alt=\"barrerouge\" src=\"images/grangeweb/barrerouge.jpg\" height=\"3\" width=\"950\" /></p>', '1', 'toolbar-l', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*'), ('89', 'rougebottom', '', '<p><img alt=\"barrerouge\" src=\"images/grangeweb/barrerouge.jpg\" height=\"3\" width=\"950\" /></p>', '1', 'footer', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
CREATE TABLE `canob_modules_menu` (   `moduleid` int(11) NOT NULL DEFAULT '0',   `menuid` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`moduleid`,`menuid`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `canob_modules_menu`  VALUES ('1', '0'), ('2', '0'), ('3', '0'), ('4', '0'), ('6', '0'), ('7', '0'), ('8', '0'), ('9', '0'), ('10', '0'), ('12', '0');
INSERT INTO `canob_modules_menu`  VALUES ('13', '0'), ('14', '0'), ('15', '0'), ('17', '102'), ('17', '103'), ('17', '104'), ('17', '105'), ('17', '106'), ('17', '107'), ('17', '108');
INSERT INTO `canob_modules_menu`  VALUES ('17', '109'), ('17', '110'), ('17', '111'), ('17', '112'), ('17', '113'), ('17', '114'), ('17', '115'), ('17', '116'), ('17', '117'), ('17', '118');
INSERT INTO `canob_modules_menu`  VALUES ('17', '119'), ('17', '120'), ('17', '121'), ('17', '122'), ('17', '123'), ('17', '124'), ('17', '125'), ('17', '126'), ('17', '127'), ('17', '128');
INSERT INTO `canob_modules_menu`  VALUES ('17', '129'), ('17', '130'), ('17', '137'), ('17', '138'), ('17', '139'), ('17', '140'), ('17', '141'), ('17', '145'), ('17', '146'), ('17', '147');
INSERT INTO `canob_modules_menu`  VALUES ('17', '148'), ('17', '149'), ('17', '155'), ('17', '156'), ('17', '157'), ('17', '158'), ('17', '159'), ('17', '160'), ('19', '103'), ('20', '103');
INSERT INTO `canob_modules_menu`  VALUES ('21', '103'), ('22', '103'), ('23', '101'), ('24', '101'), ('25', '101'), ('26', '101'), ('27', '103'), ('28', '103'), ('29', '103'), ('30', '103');
INSERT INTO `canob_modules_menu`  VALUES ('31', '0'), ('32', '0'), ('33', '103'), ('34', '103'), ('35', '103'), ('36', '103'), ('37', '103'), ('38', '0'), ('39', '0'), ('40', '0');
INSERT INTO `canob_modules_menu`  VALUES ('41', '137'), ('41', '138'), ('41', '139'), ('41', '140'), ('41', '141'), ('41', '145'), ('41', '146'), ('41', '147'), ('41', '148'), ('41', '149');
INSERT INTO `canob_modules_menu`  VALUES ('42', '103'), ('42', '108'), ('42', '109'), ('42', '110'), ('42', '111'), ('42', '112'), ('42', '113'), ('42', '114'), ('42', '115'), ('42', '116');
INSERT INTO `canob_modules_menu`  VALUES ('42', '117'), ('42', '118'), ('42', '119'), ('42', '120'), ('42', '121'), ('42', '122'), ('42', '123'), ('43', '103'), ('44', '103'), ('45', '104');
INSERT INTO `canob_modules_menu`  VALUES ('46', '104'), ('47', '104'), ('48', '107'), ('48', '124'), ('48', '128'), ('49', '107'), ('49', '124'), ('49', '128'), ('50', '106'), ('52', '105');
INSERT INTO `canob_modules_menu`  VALUES ('53', '102'), ('54', '102'), ('55', '102'), ('56', '101'), ('57', '103'), ('58', '103'), ('59', '103'), ('60', '101'), ('61', '0'), ('62', '103');
INSERT INTO `canob_modules_menu`  VALUES ('63', '103'), ('64', '103'), ('65', '103'), ('66', '105'), ('67', '105'), ('68', '105'), ('69', '105'), ('70', '101'), ('71', '103'), ('72', '103');
INSERT INTO `canob_modules_menu`  VALUES ('73', '103'), ('74', '103'), ('76', '141'), ('77', '108'), ('77', '109'), ('77', '110'), ('77', '111'), ('77', '112'), ('77', '113'), ('77', '114');
INSERT INTO `canob_modules_menu`  VALUES ('77', '115'), ('77', '116'), ('77', '117'), ('77', '118'), ('77', '119'), ('77', '120'), ('77', '121'), ('77', '122'), ('77', '123'), ('77', '137');
INSERT INTO `canob_modules_menu`  VALUES ('77', '138'), ('77', '139'), ('77', '140'), ('77', '145'), ('77', '146'), ('77', '147'), ('77', '148'), ('77', '149'), ('78', '141'), ('79', '141');
INSERT INTO `canob_modules_menu`  VALUES ('80', '0'), ('81', '0'), ('82', '0'), ('84', '0'), ('85', '0'), ('86', '0'), ('87', '0'), ('88', '0'), ('89', '0');
CREATE TABLE `canob_newsfeeds` (   `catid` int(11) NOT NULL DEFAULT '0',   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `name` varchar(100) NOT NULL DEFAULT '',   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `link` varchar(200) NOT NULL DEFAULT '',   `filename` varchar(200) DEFAULT NULL,   `published` tinyint(1) NOT NULL DEFAULT '0',   `numarticles` int(10) unsigned NOT NULL DEFAULT '1',   `cache_time` int(10) unsigned NOT NULL DEFAULT '3600',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL DEFAULT '0',   `rtl` tinyint(4) NOT NULL DEFAULT '0',   `access` int(10) unsigned NOT NULL DEFAULT '0',   `language` char(7) NOT NULL DEFAULT '',   `params` text NOT NULL,   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) NOT NULL DEFAULT '',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `metakey` text NOT NULL,   `metadesc` text NOT NULL,   `metadata` text NOT NULL,   `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   PRIMARY KEY (`id`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_state` (`published`),   KEY `idx_catid` (`catid`),   KEY `idx_createdby` (`created_by`),   KEY `idx_language` (`language`),   KEY `idx_xreference` (`xreference`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_overrider` (   `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',   `constant` varchar(255) NOT NULL,   `string` text NOT NULL,   `file` varchar(255) NOT NULL,   PRIMARY KEY (`id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_phocadownload` (   `id` int(11) unsigned NOT NULL AUTO_INCREMENT,   `catid` int(11) NOT NULL DEFAULT '0',   `sectionid` int(11) NOT NULL DEFAULT '0',   `owner_id` int(11) NOT NULL DEFAULT '0',   `sid` int(11) NOT NULL DEFAULT '0',   `title` varchar(250) NOT NULL DEFAULT '',   `alias` varchar(255) NOT NULL DEFAULT '',   `filename` varchar(250) NOT NULL DEFAULT '',   `filesize` int(11) NOT NULL DEFAULT '0',   `filename_play` varchar(250) NOT NULL DEFAULT '',   `filename_preview` varchar(250) NOT NULL DEFAULT '',   `author` varchar(255) NOT NULL DEFAULT '',   `author_email` varchar(255) NOT NULL DEFAULT '',   `author_url` varchar(255) NOT NULL DEFAULT '',   `license` varchar(255) NOT NULL DEFAULT '',   `license_url` varchar(255) NOT NULL DEFAULT '',   `video_filename` varchar(255) NOT NULL DEFAULT '',   `image_filename` varchar(255) NOT NULL DEFAULT '',   `image_filename_spec1` varchar(255) NOT NULL DEFAULT '',   `image_filename_spec2` varchar(255) NOT NULL DEFAULT '',   `image_download` varchar(255) NOT NULL DEFAULT '',   `link_external` varchar(255) NOT NULL DEFAULT '',   `mirror1link` varchar(255) NOT NULL DEFAULT '',   `mirror1title` varchar(255) NOT NULL DEFAULT '',   `mirror1target` varchar(10) NOT NULL DEFAULT '',   `mirror2link` varchar(255) NOT NULL DEFAULT '',   `mirror2title` varchar(255) NOT NULL DEFAULT '',   `mirror2target` varchar(10) NOT NULL DEFAULT '',   `description` text,   `features` text,   `changelog` text,   `notes` text,   `userid` int(11) NOT NULL DEFAULT '0',   `version` varchar(255) NOT NULL DEFAULT '',   `directlink` tinyint(1) NOT NULL DEFAULT '0',   `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `hits` int(11) NOT NULL DEFAULT '0',   `textonly` tinyint(1) NOT NULL DEFAULT '0',   `published` tinyint(1) NOT NULL DEFAULT '0',   `approved` tinyint(3) unsigned NOT NULL DEFAULT '0',   `checked_out` int(11) NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL DEFAULT '0',   `access` int(11) unsigned NOT NULL DEFAULT '0',   `confirm_license` int(11) NOT NULL DEFAULT '0',   `unaccessible_file` int(11) NOT NULL DEFAULT '0',   `params` text,   `metakey` text,   `metadesc` text,   `metadata` text,   `language` char(7) NOT NULL DEFAULT '',   PRIMARY KEY (`id`),   KEY `catid` (`catid`,`published`) ) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;
INSERT INTO `canob_phocadownload`  VALUES ('1', '4', '0', '0', '0', 'favicon', 'favicon', 'favicon.ico', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '<p>C\'est la \"petite virgule\" qui apparaît dans la ligne d\'adresse du site.</p>', '', '', '', '0', '', '0', '2012-02-25 16:51:16', '2012-02-25 16:51:16', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '1', '1', '0', '0', NULL, '', '', NULL, '*'), ('2', '4', '0', '0', '0', 'Logo FR', 'logo-fr', 'logo.png', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '<p>La fameuse apostrophe</p>\r\n<p><img alt=\"logo\" src=\"images/grangeweb/logo.png\" height=\"100\" width=\"120\" /></p>', '', '', '', '0', '', '0', '2012-02-25 16:52:28', '2012-02-25 16:52:28', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '2', '1', '0', '0', NULL, '', '', NULL, '*'), ('3', '5', '0', '0', '0', 'JCE - Plugins Mediabox Joomla 1.7', 'jce-plugins-mediabox-joomla-1-7', 'plg_jcemediabox_112_joomla17_FR-EN.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-02-27 08:21:20', '2012-02-27 08:21:20', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '1', '1', '0', '0', NULL, '', '', NULL, '*'), ('4', '5', '0', '0', '0', 'JCE - Plugins Mediabox Joomla 1.5', 'jce-plugins-mediabox-joomla-1-5', 'plg_jcemediabox_112_joomla15_FR-EN.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-02-27 08:21:54', '2012-02-27 08:21:54', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '2', '1', '0', '0', NULL, '', '', NULL, '*'), ('5', '6', '0', '0', '0', 'JCE - Plugins FileManager', 'jce-plugins-filemanager', 'jce_filemanager_2010.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-02-27 08:23:10', '2012-02-27 08:23:10', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '1', '1', '0', '0', NULL, '', '', NULL, '*'), ('6', '6', '0', '0', '0', 'JCE - Plugins Image Manager', 'jce-plugins-image-manager', 'jce_imgmanager_ext_208.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-02-27 08:23:38', '2012-02-27 08:23:38', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '2', '1', '0', '0', NULL, '', '', NULL, '*'), ('7', '6', '0', '0', '0', 'JCE - Plugins Media Manager', 'jce-plugins-media-manager', 'jce_mediamanager_206.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-02-27 08:23:56', '2012-02-27 08:23:56', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '3', '1', '0', '0', NULL, '', '', NULL, '*'), ('9', '12', '0', '0', '0', 'JCal Pro 3.0.0', 'jcal-pro-3-0-0', 'pkg_jcalpro_3.0.0.beta3.3003.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-03-12 11:09:40', '2012-03-12 11:09:40', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '1', '1', '0', '0', NULL, '', '', NULL, '*'), ('10', '13', '0', '0', '0', 'JEvents - Composant 2.1.10', 'jevents-composant-2-1-10', 'com_jevents_2.1.10a.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-03-12 11:11:00', '2012-03-12 11:11:00', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '1', '1', '0', '0', NULL, '', '', NULL, '*'), ('11', '13', '0', '0', '0', 'JEvents - language pack FR', 'jevents-language-pack-fr', 'fr-FR_JEvents_2.1_J25.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-03-12 11:11:37', '2012-03-12 11:11:37', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '2', '1', '0', '0', NULL, '', '', NULL, '*');
INSERT INTO `canob_phocadownload`  VALUES ('12', '13', '0', '0', '0', 'JEvents - Module calendrier', 'jevents-module-calendrier', 'mod_jevents_cal_2.1.3.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-03-12 11:12:19', '2012-03-12 11:12:19', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '3', '1', '0', '0', NULL, '', '', NULL, '*'), ('13', '13', '0', '0', '0', 'JEvents - Module derniers Events', 'jevents-module-derniers-events', 'mod_jevents_latest_2.1.4.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-03-12 11:12:59', '2012-03-12 11:12:59', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '4', '1', '0', '0', NULL, '', '', NULL, '*'), ('14', '8', '0', '0', '0', 'DocMan 1.6.0 FR', 'docman-1-6-0-fr', 'docman_v1.6.0_fr-FR_r37.tar.gz', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-03-12 11:14:46', '2012-03-12 11:14:46', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '1', '1', '0', '0', NULL, '', '', NULL, '*'), ('15', '8', '0', '0', '0', 'DocMan 1.6.3', 'docman-1-6-3', 'docman_v1.6.3.r1541.tar.gz', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-03-12 11:15:11', '2012-03-12 11:15:11', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '2', '1', '0', '0', NULL, '', '', NULL, '*'), ('16', '9', '0', '0', '0', 'RSForm - Composant', 'rsform-composant', 'com_rsform.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-03-12 11:16:19', '2012-03-12 11:16:19', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '1', '1', '0', '0', NULL, '', '', NULL, '*'), ('17', '9', '0', '0', '0', 'RSForm - Language FR', 'rsform-language-fr', 'French.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-03-12 11:17:41', '2012-03-12 11:17:41', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '2', '1', '0', '0', NULL, '', '', NULL, '*'), ('18', '9', '0', '0', '0', 'RSForm - Module', 'rsform-module', 'mod_rsform.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-03-12 11:18:08', '2012-03-12 11:18:08', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '3', '1', '0', '0', NULL, '', '', NULL, '*'), ('19', '9', '0', '0', '0', 'RSForm - Plugin', 'rsform-plugin', 'plg_content.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-03-12 11:18:37', '2012-03-12 11:18:37', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '4', '1', '0', '0', NULL, '', '', NULL, '*'), ('20', '10', '0', '0', '0', 'AcePolls', 'acepolls', 'com_acepolls_j25.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-03-12 11:19:37', '2012-03-12 11:19:37', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '1', '1', '0', '0', NULL, '', '', NULL, '*'), ('21', '2', '0', '0', '0', 'DocMan 1.6.4 - complet', 'docman-1-6-4-complet', 'DocMan164.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-05-15 07:49:48', '2012-05-15 07:49:48', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '3', '1', '0', '0', NULL, '', '', NULL, '*');
INSERT INTO `canob_phocadownload`  VALUES ('22', '15', '0', '0', '0', 'Mailster Pro', 'mailster-pro', 'com_mailster_0.3.7_pro.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-05-15 07:52:59', '2012-05-15 07:52:59', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '1', '1', '0', '0', NULL, '', '', NULL, '*'), ('23', '14', '0', '0', '0', 'Site exemple complet (Joomla + Thème + Extensions)', 'site-exemple-complet-joomla-theme-extensions', 'IAG-sampleJoomlaSite-20120608.zip', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2012-06-08 15:10:08', '2012-06-08 15:10:08', '0000-00-00 00:00:00', '3', '0', '1', '1', '0', '0000-00-00 00:00:00', '1', '1', '0', '0', NULL, '', '', NULL, '*');
CREATE TABLE `canob_phocadownload_categories` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `parent_id` int(11) NOT NULL DEFAULT '0',   `section` int(11) NOT NULL DEFAULT '0',   `title` varchar(255) NOT NULL DEFAULT '',   `name` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) NOT NULL DEFAULT '',   `image` varchar(255) NOT NULL DEFAULT '',   `image_position` varchar(30) NOT NULL DEFAULT '',   `description` text,   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `editor` varchar(50) DEFAULT NULL,   `ordering` int(11) NOT NULL DEFAULT '0',   `access` int(11) unsigned NOT NULL DEFAULT '0',   `uploaduserid` text,   `accessuserid` text,   `deleteuserid` text,   `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `count` int(11) NOT NULL DEFAULT '0',   `params` text,   `hits` int(11) NOT NULL DEFAULT '0',   `metakey` text,   `metadesc` text,   `metadata` text,   `language` char(7) NOT NULL DEFAULT '',   PRIMARY KEY (`id`),   KEY `cat_idx` (`section`,`published`,`access`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`) ) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;
INSERT INTO `canob_phocadownload_categories`  VALUES ('1', '11', '0', 'Editeur de texte - JCE', '', 'editeur-de-texte', '', '', '<p><strong>JCE</strong> est un éditeur de texte très performant. Son téléchargement est libre mais certaines estensions (plugins) sont payants.</p>\r\n<p>Pour l\'installer suivez la procédure suivante :</p>\r\n<ol>\r\n<li><a href=\"index.php/liens?task=weblink.go&id=5\">Téléchargez JCE </a>et installez-le dans votre site</li>\r\n<li>Téléchargez le plugin \"<strong>Mediabox</strong>\" selon votre version de Joomla et installez-le comme les autres modules</li>\r\n<li>Téléchargez les plugins complémentaire (<strong>FileManager, ImageManager et MediaManager</strong>) et installez ces plugins à partir du composant JCE lui-même.</li>\r\n</ol>', '1', '0', '0000-00-00 00:00:00', NULL, '10', '1', '0', '0', '0', '2012-02-25 16:29:10', '0', NULL, '0', '', '', NULL, '*'), ('2', '11', '0', 'Téléchargements', '', 'telechargements', '', '', '', '1', '0', '0000-00-00 00:00:00', NULL, '2', '1', '0', '0', '0', '2012-02-25 16:29:44', '0', NULL, '0', '', '', NULL, '*'), ('3', '2', '0', 'Phoca Downloads', '', 'phoca-downloads', '', '', '<p>Pourquoi sauvegarder des fichier libre en téléchargement ? Afin d\'être certain d\'installer dans votre site la dernière version de ce composant, je vous conseille d\'aller vous servir directement à la source.</p>\r\n<p>Sous la rubrique \"<a href=\"index.php?option=com_weblinks&view=categories&id=0&Itemid=158\">Liens</a>\" vous trouverez les informations nécessaires pour vous rendre sur le <a target=\"_blank\" href=\"index.php/liens?task=weblink.go&id=4\">site de Phoca </a>et télécharger les dernières versions de ce logiciel !</p>', '1', '0', '0000-00-00 00:00:00', NULL, '3', '1', '0', '0', '0', '2012-02-25 16:29:58', '0', NULL, '0', '', '', NULL, '*'), ('4', '0', '0', 'Images et Logos', '', 'images-et-logos', '', '', '', '1', '0', '0000-00-00 00:00:00', NULL, '4', '1', '0', '0', '0', '2012-02-25 16:49:10', '0', NULL, '0', '', '', NULL, '*'), ('5', '1', '0', 'Plugins JCE - MediaBox', '', 'plugins', '', '', '<p>Plugins JCE à installer à partir du menu \"Extensions\" - \"Gestion des extensions\"</p>', '1', '0', '0000-00-00 00:00:00', NULL, '5', '1', '0', '0', '0', '2012-02-27 08:15:18', '0', NULL, '0', '', '', NULL, '*'), ('6', '1', '0', 'Plugins JCE - Managers', '', 'plugins', '', '', '<p>Plugins JCE à installer à partir de JCE</p>', '1', '0', '0000-00-00 00:00:00', NULL, '5', '1', '0', '0', '0', '2012-02-27 08:15:18', '0', NULL, '0', '', '', NULL, '*'), ('7', '11', '0', 'Agenda', '', 'agenda', '', '', '', '1', '0', '0000-00-00 00:00:00', NULL, '6', '1', '0', '0', '0', '2012-03-12 11:05:23', '0', NULL, '0', '', '', NULL, '*'), ('8', '11', '0', 'Gestion de documents', '', 'gestion-de-documents', '', '', '', '1', '0', '0000-00-00 00:00:00', NULL, '7', '1', '0', '0', '0', '2012-03-12 11:05:58', '0', NULL, '0', '', '', NULL, '*'), ('9', '11', '0', 'Formulaires', '', 'formulaires', '', '', '', '1', '0', '0000-00-00 00:00:00', NULL, '8', '1', '0', '0', '0', '2012-03-12 11:06:07', '0', NULL, '0', '', '', NULL, '*'), ('10', '11', '0', 'Sondages', '', 'sondages', '', '', '', '1', '0', '0000-00-00 00:00:00', NULL, '9', '1', '0', '0', '0', '2012-03-12 11:06:16', '0', NULL, '0', '', '', NULL, '*');
INSERT INTO `canob_phocadownload_categories`  VALUES ('11', '0', '0', 'Extensions', '', 'extensions', '', '', '<p>Voici une liste des Extensions que nous a fournies Monsieur Boisset lors de son cours de formation Joomla organisé à l\'IAG en février 2012.</p>\r\n<p>Dans la mesure du possible, essayez de trouver si ces extensions sont disponibles librement au téléchargement. Si tel est le cas, je vous conseille fortement de privilégier les dernières versions de ces composants, modules et autres Plugins. Vous y gagnerez en performance et également en fonctionnalité.</p>', '1', '0', '0000-00-00 00:00:00', NULL, '10', '1', '0', '0', '0', '2012-03-12 11:06:29', '0', NULL, '0', '', '', NULL, '*'), ('12', '7', '0', 'JCal Pro', '', 'jcal-pro', '', '', '', '1', '0', '0000-00-00 00:00:00', NULL, '11', '1', '0', '0', '0', '2012-03-12 11:08:25', '0', NULL, '0', '', '', NULL, '*'), ('13', '7', '0', 'JEvents', '', 'jevents', '', '', '', '1', '0', '0000-00-00 00:00:00', NULL, '12', '1', '0', '0', '0', '2012-03-12 11:08:38', '0', NULL, '0', '', '', NULL, '*'), ('14', '0', '0', 'Joomla 2.5 + Template Grangeweb', '', 'joomla-2-5-template-grangeweb', '', '', '', '1', '0', '0000-00-00 00:00:00', NULL, '13', '1', '0', '0', '0', '2012-03-12 11:21:21', '0', NULL, '0', '', '', NULL, '*'), ('15', '11', '0', 'Mailing List', '', 'mailing-list', '', '', '', '1', '0', '0000-00-00 00:00:00', NULL, '14', '1', '0', '0', '0', '2012-05-15 07:52:33', '0', NULL, '0', '', '', NULL, '*');
CREATE TABLE `canob_phocadownload_file_votes` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `fileid` int(11) NOT NULL DEFAULT '0',   `userid` int(11) NOT NULL DEFAULT '0',   `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `rating` tinyint(1) NOT NULL DEFAULT '0',   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL DEFAULT '0',   `params` text,   `language` char(7) NOT NULL DEFAULT '',   PRIMARY KEY (`id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_phocadownload_file_votes_statistics` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `fileid` int(11) NOT NULL DEFAULT '0',   `count` int(11) NOT NULL DEFAULT '0',   `average` float(8,6) NOT NULL DEFAULT '0.000000',   `language` char(7) NOT NULL DEFAULT '',   PRIMARY KEY (`id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_phocadownload_layout` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `categories` text,   `category` text,   `file` text,   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `params` text,   PRIMARY KEY (`id`) ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `canob_phocadownload_layout`  VALUES ('1', '<div class=\"pd-categoriesbox\">\n<div class=\"pd-title\">{pdtitle}</div>\n{pdsubcategories}\n{pdclear}\n</div>', '<div class=\"pd-filebox\">\n{pdfiledesctop}\n{pdfile}\n<div class=\"pd-buttons\">{pdbuttondownload}</div>\n<div class=\"pd-buttons\">{pdbuttondetails}</div>\n<div class=\"pd-buttons\">{pdbuttonpreview}</div>\n<div class=\"pd-buttons\">{pdbuttonplay}</div>\n<div class=\"pd-mirrors\">{pdmirrorlink2} {pdmirrorlink1}</div>\n<div class=\"pd-rating\">{pdrating}</div>\n<div class=\"pd-tags\">{pdtags}</div>\n{pdfiledescbottom}\n<div class=\"pd-cb\"></div>\n</div>', '<div class=\"pd-filebox\">\n{pdimage}\n{pdfile}\n{pdfilesize}\n{pdversion}\n{pdlicense}\n{pdauthor}\n{pdauthoremail}\n{pdfiledate}\n{pddownloads}\n{pddescription}\n{pdfeatures}\n{pdchangelog}\n{pdnotes}\n<div class=\"pd-mirrors\">{pdmirrorlink2} {pdmirrorlink1}</div>\n<div class=\"pd-report\">{pdreportlink}</div>\n<div class=\"pd-rating\">{pdrating}</div>\n<div class=\"pd-tags\">{pdtags}</div>\n<div class=\"pd-cb\"></div>\n</div>', '42', '2012-03-12 11:19:48', NULL);
CREATE TABLE `canob_phocadownload_licenses` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `title` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) NOT NULL DEFAULT '',   `description` text,   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `published` tinyint(1) NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `language` char(7) NOT NULL DEFAULT '',   PRIMARY KEY (`id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_phocadownload_tags` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `title` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) NOT NULL DEFAULT '',   `link_cat` int(11) NOT NULL DEFAULT '0',   `link_ext` varchar(255) NOT NULL DEFAULT '',   `description` text,   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL DEFAULT '0',   `params` text,   `language` char(7) NOT NULL DEFAULT '',   PRIMARY KEY (`id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_phocadownload_tags_ref` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `fileid` int(11) NOT NULL DEFAULT '0',   `tagid` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   UNIQUE KEY `id` (`id`),   UNIQUE KEY `i_fileid` (`fileid`,`tagid`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `canob_phocadownload_user_stat` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `fileid` int(11) NOT NULL DEFAULT '0',   `userid` int(11) NOT NULL DEFAULT '0',   `count` int(11) NOT NULL DEFAULT '0',   `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `published` tinyint(1) NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `language` char(7) NOT NULL DEFAULT '',   PRIMARY KEY (`id`) ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `canob_phocadownload_user_stat`  VALUES ('1', '23', '43', '3', '2012-07-06 16:38:14', '0', '0', '');
CREATE TABLE `canob_redirect_links` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `old_url` varchar(255) NOT NULL,   `new_url` varchar(255) NOT NULL,   `referer` varchar(150) NOT NULL,   `comment` varchar(255) NOT NULL,   `hits` int(10) unsigned NOT NULL DEFAULT '0',   `published` tinyint(4) NOT NULL,   `created_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   PRIMARY KEY (`id`),   UNIQUE KEY `idx_link_old` (`old_url`),   KEY `idx_link_modifed` (`modified_date`) ) ENGINE=MyISAM AUTO_INCREMENT=192 DEFAULT CHARSET=utf8;
